block('b-agencies-list')(

    def()(function() {
        var data = this.data,
            csrfToken = this['i-global'].csrf_token,
            columns = [
                {
                    key: 'login',
                    title: iget2('b-agencies-list', 'login', 'Логин'),
                    transformData: function(row) {

                        var res = [{
                            block: 'link',
                            content: row.login,
                            url: u.formatUrl({
                                host: data.script,
                                query: {
                                    cmd: 'showClients',
                                    ulogin: row.login
                                }
                            })
                        }];

                        (row.not_resident === 'Yes') && res.push({
                            block: 'b-agencies-list',
                            elem: 'login-prop',
                            title: iget2('b-agencies-list', 'nerezident', 'Нерезидент'),
                            content: ['&nbsp;(', iget2('b-agencies-list', 'nr', 'нр'), ')']
                        });

                        hasLoginRights('super_control', 'manager_control', 'support_control', 'limited_support_control') && res.push({
                            block: 'b-agencies-list',
                            elem: 'login-prop',
                            content: [
                                '&nbsp;(',
                                {
                                    block: 'link',
                                    url: u.formatUrl({
                                        host: u.consts('balance_admin'),
                                        path: 'clients.xml',
                                        query: {
                                            login: row.login
                                        }
                                    }),
                                    content: iget2('b-agencies-list', 'billing', 'биллинг')
                                },
                                row.is_agency_chief != 0 && (', ' + iget2('b-agencies-list', 'glavnyy', 'главный') + ' '),
                                row.is_agency_chief != 0 && {
                                    block: 'link',
                                    content: row.ClientID,
                                    url: u.formatUrl({
                                        host: u.consts('balance_admin'),
                                        path: 'clients.xml',
                                        query: {
                                            client_id: row.ClientID
                                        }
                                    })
                                },
                                ')'
                            ]
                        });

                        return res;
                    }.bind(this)
                },
                {
                    key: 'agency_name',
                    title: iget2('b-agencies-list', 'nazvanie', 'Название'),
                    transformData: function(row) {
                        //DIRECT-30614 фильтруем случай, когда приходит объект null или undefined
                        return row.agency_name && row.agency_name.toString() || '';
                    }
                },
                {
                    key: 'managers_of_agency',
                    title: iget2('b-agencies-list', 'menedzher', 'Менеджер'),
                    transformData: function(row) {
                        return row.managers_of_agency && row.managers_of_agency.map(function(m) {
                            return {
                                block: 'link',
                                mix: [
                                    {
                                        block: 'b-agencies-list',
                                        elem: 'manager-link',
                                        elemMods: {
                                            'is-main': m.is_main_manager ? 'yes' : undefined
                                        }
                                    }
                                ],
                                //DIRECT-30614 фильтруем случай, когда приходит объект null или undefined
                                url: 'mailto:' + (m.managers_email && m.managers_email.toString() || ''),
                                content: (m.managers_FIO && m.managers_FIO.toString() || '') +
                                    ' (' + (m.managers_login && m.managers_login.toString() || '') + ')'
                            };
                        });
                    }
                },
                {
                    key: 'phone',
                    title: iget2('b-agencies-list', 'telefon', 'Телефон'),
                    transformData: function(row) {
                        return row.phone && row.phone.toString();
                    }
                },
                {
                    key: 'email',
                    title: iget2('b-agencies-list', 'email', 'email'),
                    transformData: function(row) {
                        return row.email ?
                            ({
                                block: 'link',
                                url: 'mailto:' + row.email,
                                content: row.email
                            }) :
                            '';
                    }
                },
                hasLoginRights('support_control', 'limited_support_control', 'super_control', 'is_developer') && {
                    key: 'edit',
                    sortDisable: true,
                    transformData: function(row) {
                        return row.rbac_role != 'empty' ?
                            ({
                                block: 'link',
                                content: iget2('b-agencies-list', 'redaktirovat', 'редактировать'),
                                url: u.formatUrl({
                                    host: data.SCRIPT_CLEAR,
                                    query: {
                                        cmd: 'modifyUser',
                                        csrf_token: csrfToken,
                                        ulogin: row.login,
                                        rcmd: 'showSearchPage'
                                    }
                                })
                            }) :
                            '';
                    }
                }
            ];

        return this.ctx.agencies ? applyNext({
            'ctx.columns': columns
        }) : '';
    }),

    content()(function() {
        var res = [{
            elem: 'header',
            content: iget2('b-agencies-list', 'agentstva', 'Агентства') + ':'
        }];

        res.push({
            block: 'b-data-table',
            mix: [
                {
                    block: 'b-agencies-list',
                    elem: 'table'
                },
                {
                    block: 'b-style-table',
                    mods: {
                        theme: 'gray-list'
                    }
                }
            ],
            mods: {
                sortable: 'server',
                'has-num-column': 'yes'
            },
            columns: this.ctx.columns,
            rows: this.ctx.agencies,
            mixes: {
                row: [{
                    block: 'b-style-table',
                    elem: 'row'
                }],
                headerRow: [{
                    block: 'b-style-table',
                    elem: 'head'
                }],
                cell: [{
                    block: 'b-style-table',
                    elem: 'cell'
                }],
                headerCell: [{
                    block: 'b-style-table',
                    elem: 'cell'
                }]
            }
        });

        return this.ctx.agencies.length ?
            res : {
                elem: 'empty-content',
                content: iget2('b-agencies-list', 'agentstva-ne-naydeny', 'Агентства не найдены.')
            };
    })
);
