BEM.DOM.decl('b-agency-banner', {
    onSetMod: {
        js: function() {
            var dna = window.dna,
                items = this.params.items;

            if (!dna) {
                throw new Error('An error has occurred in loading DNA dependencies');
            }

            function onWelcomeBannerShow(banner) {
                switch (banner) {
                    case 'yandex':
                        BEM.blocks['b-metrika2'].reachGoal('SHOW_YANDEX_BANNER_CREATE_CAMP');
                        break;
                    case 'agency':
                        BEM.blocks['b-metrika2'].reachGoal('SHOW_AGENCY_BANNER_CREATE_CAMP');
                        break;
                    case 'freelancer':
                        BEM.blocks['b-metrika2'].reachGoal('SHOW_FREELANCER_BANNER_CREATE_CAMP');
                        break;
                    default:
                        throw new Error('An error has occurred while displaying the banner: "' + banner + '"');
                }
            }

            function onWelcomeBannerClick(banner) {
                switch (banner) {
                    case 'yandex':
                        BEM.blocks['b-metrika2'].reachGoal('CLICK_YANDEX_BANNER_CREATE_CAMP');
                        break;
                    case 'agency':
                        BEM.blocks['b-metrika2'].reachGoal('CLICK_AGENCY_BANNER_CREATE_CAMP');
                        break;
                    case 'freelancer':
                        BEM.blocks['b-metrika2'].reachGoal('CLICK_FREELANCER_BANNER_CREATE_CAMP');
                        break;
                    default:
                        throw new Error('An error has occurred in click on the banner: "' + banner + '"');
                }
            }

            this._renderDna(dna, items, onWelcomeBannerShow, onWelcomeBannerClick);
        }
    },

    /**
     * Render DNA root component
     */
    _renderDna: function(dna, items, onWelcomeBannerShow, onWelcomeBannerClick) {
        var component = dna.components.FirstCampaignTizer,
            dnaRootComponent = dna.reactCreateElement(component, {
                heading: iget2('b-agency-banner', 'teaser-heading', 'Затрудняетесь с настройкой? Обратитесь к специалистам'),
                items: {
                    suggestYandexService: items.suggestYandexService,
                    suggestExternalService: items.suggestExternalService
                },
                onWelcomeBannerShow: onWelcomeBannerShow,
                onWelcomeBannerClick: onWelcomeBannerClick
            }, null);

        dna.reactDOMRender(dnaRootComponent, this.domElem.get(0));
    }
});
