block('b-agency-select')(
    js()(true),
    content()(function() {
        var forAgencies = this.ctx.agencies || [],
            options = this.ctx.options || {},
            addToDropdown = options.addToDropdown,
            newCampBelonging = options.newCampBelonging,
            newCampSelfType = options.newCampSelfType;

        return {
            block: 'select',
            content: [
                {
                    block: 'button',
                    content: iget2('b-agency-select', 'agentstvo', 'Агентство')
                },
                {
                    elem: 'control', // нативный селект
                    content: (function() {
                        var options = forAgencies.map(function(forAgency) {
                            var attrs = { value: u.escapeHTML(forAgency.login) };

                            if (newCampBelonging == forAgency.login)
                                attrs.selected = 'selected';

                            return {
                                elem: 'option',
                                attrs: attrs,
                                content: u.escapeHTML(forAgency.agency_name)
                            };
                        });

                        if (addToDropdown == 'full')
                            options.unshift({
                                elem: 'option',
                                attrs: {
                                    value: '',
                                    selected: newCampBelonging == '$self$'
                                },
                                content: newCampSelfType == 'self' ?
                                    iget2('b-agency-select', 'dlya-samostoyatelnogo-obsluzhivaniya', 'для самостоятельного обслуживания') :
                                    iget2('b-agency-select', 'na-obsluzhivanie-menedzherom', 'на обслуживание менеджером')
                            });

                        return options;
                    })()
                }
            ]
        };
    })
);
