block('b-ajax-captcha')(
    js()(function() {
        return {
            captchaId: this.ctx.captchaId
        };
    }),

    content()(function() {
        return [
            !!this.ctx.title && {
                elem: 'title',
                content: this.ctx.title
            },
            {
                elem: 'form',
                attrs: {
                    action: '#'
                },
                content: [
                    {
                        elem: 'text',
                        content: [
                            iget2(
                                'b-ajax-captcha',
                                'dlya-podtverzhdeniya-togo-chto',
                                'Для подтверждения того, что вы человек, а не программа, введите, пожалуйста, контрольные символы.'
                            ),
                            ' ',
                            iget2(
                                'b-ajax-captcha',
                                'zapros-simvolov-periodicheski-predprinimaetsya',
                                'Запрос символов периодически предпринимается для более надежного обеспечения конфиденциальности вашей информации.'
                            )
                        ]
                    },
                    {
                        elem: 'capcha',
                        content: [
                            {
                                elem: 'img',
                                attrs: {
                                    src: this.ctx.imgUrl
                                }
                            },
                            {
                                elem: 'hint',
                                content: iget2('b-ajax-captcha', 'vvedite-simvoly-kotorye-vy', 'Введите символы, которые вы видите на картинке')
                            },
                            '<br/>',
                            '<br/>',
                            {
                                block: 'link',
                                mods: {
                                    pseudo: 'yes'
                                },
                                mix: [{
                                    block: 'b-ajax-captcha',
                                    elem: 'refresh'
                                }],
                                content: [
                                    {
                                        block: 'b-icon',
                                        mods: {
                                            type: 'refresh'
                                        },
                                        mix: [{ block: 'link', elem: 'icon' }],
                                        attrs: {
                                            align: 'left'
                                        }
                                    },
                                    {
                                        elem: 'inner',
                                        content: iget2('b-ajax-captcha', 'pokazat-druguyu-kartinku', 'Показать другую картинку')
                                    }
                                ]
                            },
                            {
                                elem: 'loading',
                                content: iget2('b-ajax-captcha', 'obnovlyaetsya', 'обновляется...')
                            },
                            {
                                block: 'i-clearfix'
                            }
                        ]
                    },
                    {
                        block: 'input',
                        mix: [{
                            block: 'b-ajax-captcha',
                            elem: 'input'
                        }],
                        js: {
                            autoFocus: 'yes'
                        },
                        mods: {
                            size: 'm',
                            theme: 'normal'
                        },
                        content: {
                            elem: 'control'
                        }
                    },
                    {
                        block: 'button',
                        mods: {
                            size: 'm',
                            theme: 'normal'
                        },
                        type: 'submit',
                        content: iget2('b-ajax-captcha', 'prodolzhit', 'Продолжить')
                    }
                ]
            }
        ];
    }),

    elem('form').tag()('form'),
    elem('text').tag()('p'),
    elem('title').tag()('h2'),
    elem('hint').tag()('span'),
    elem('loading').tag()('span'),
    elem('img')(
        tag()('img'),

        attrs()({
            align: 'left'
        })
    )
);
