BEM.DOM.decl('b-ajax-captcha', {
    _captchaId: null,
    _refreshRequest: null,

    onSetMod: {

        js: function() {
            this._captchaId = this.params.captchaId;

            this.bindTo('form', 'submit', function(event) {
                event.preventDefault();

                this.trigger('submit', {
                    captchaId: this._captchaId,
                    captchaCode: this.findBlockOn('input', 'input').val()
                });
            });

            this.bindTo('refresh', 'click', this._refresh);
        }
    },

    /**
     * Запрос новой картинки для капчи
     * @private
     */
    _refresh: function() {

        // если объект запроса не был сформирован, то сделаем его
        if (!this._refreshRequest)
            this._refreshRequest = BEM.create('i-request_type_ajax', {
                url: u.parseUrl(location.href).path,
                cache: false,
                type: 'GET',
                dataType: 'json',
                onError: (function(jqxhr) {
                    var response;

                    if (jqxhr.status === 429) {
                        try {
                            this._updateImage(JSON.parse(jqxhr.responseText));
                        } catch (e) {
                            this.delMod('state');
                        }
                    }
                }).bind(this)
            });

        this.setMod('state', 'loading');

        this._refreshRequest.get(
            { cmd: 'showCaptcha', ajax: true },
            this._updateImage,
            { callbackCtx: this });
    },

    /**
     * Отрисовка новой картинки
     * @param {Object} data данные для отрисовки
     * @param {String} data.captcha_id идентификатор капчи
     * @param {String} data.captcha_url адрес картинки
     * @private
     */
    _updateImage: function(data) {
        this._captchaId = data.captcha_id || 0;

        this.elem('img').attr('src', data.captcha_url || 0);

        this.setMod('state', '');
    }
});
