block('b-api-management-apps').content()(function() {
    var apps = this.data.applications || [],
        appsLength = apps.length,
        domain = this.data.yandex_domain,
        domainZone = (domain == 'yandex.com' || domain == 'yandex.com.tr') ? 'com' : 'ru',
        getRow = function(left, middle, right) {
            return [
                {
                    elem: 'cell-right',
                    content: right
                },
                {
                    elem: 'cell-shrink-wrap',
                    content: [
                        {
                            elem: 'cell-left',
                            content: left
                        },
                        {
                            elem: 'cell-middle',
                            content: middle
                        }
                    ]
                }
            ];
        };

    return [
        {
            block: 'b-api-management',
            elem: 'title',
            content: iget2('b-api-management-apps', 'prilozheniya', 'Приложения')
        },
        {
            block: 'b-api-management',
            elem: 'row',
            content: iget2(
                'b-api-management-apps',
                'spisok-programmnyh-produktov-kotorym',
                'Список программных продуктов, которым выдан доступ к текущему аккаунту в Директе. Отозвать доступ для любого из перечисленных приложений можно на {link}',
                {
                    link: function(text) {
                        return {
                            block: 'link',
                            url: u.formatUrl({
                                protocol: 'https',
                                host: 'oauth.yandex.' + domainZone,
                                path: 'list_tokens'
                            }),
                            content: text
                        };
                    }(iget2('b-api-management-apps', 'spisok-programmnyh-produktov-kotorym-param-link', 'странице сервиса OAuth')),

                    context: 'link - странице сервиса OAuth'
                }
            )
        },
        {
            block: 'b-api-management',
            elem: 'row',
            content: {
                block: 'b-api-management',
                elem: 'table',
                content: [
                    {
                        elem: 'table-header',
                        content: getRow(iget2('b-api-management-apps', 'nazvanie-prilozheniya', 'Название приложения'), iget2('b-api-management-apps', 'opisanie', 'Описание'), iget2('b-api-management-apps', 'zaprosov-segodnya', 'Запросов сегодня'))
                    },
                    apps.map(function(app, idx) {
                        return {
                            elem: 'table-row',
                            elemMods: {
                                trailer: idx + 1 === appsLength ? 'yes' : ''
                            },
                            content: getRow(
                                u.escapeHTML(app.name),
                                app.description ? u.escapeHTML(app.description) : '&ndash;',
                                u.escapeHTML(app.queries_cnt))
                        };
                    })
                ]
            }
        }
    ];
});
