block('b-api-management-cer-list').mod('type', 'admin').elem('table').content()(function() {
    var items = {
        elem: 'empty',
        content: iget2('b-api-management-cer-list', 'spisok-pust', 'список пуст')
    };

    if (this.ctx.items.length) {
        items = this.ctx.items.map(function(item) {
            if (item.app_access) {
                item.app_access.check_time = u.formatDate(item.app_access.check_time);
            }

            return {
                block: 'b-cert-list-item',
                mods: {
                    type: 'admin'
                },
                data: item
            };
        });
    }

    return [
        {
            elem: 'body',
            content: items
        },
        {
            block: 'b-outboard-controls',
            mix: {
                block: 'b-api-management-cer-list',
                elem: 'moderation'
            },
            js: {
                id: 'cer-list'
            },
            content: {
                elem: 'popup',
                directions: ['left'],
                autoclosable: 'no',
                acceptButtonText: iget2('b-api-management-cer-list', 'izmenit-status', 'Изменить статус'),
                innerBlock: applyCtx({
                    block: 'b-api-management-cert-moderation'
                })
            }
        },
        {
            block: 'b-outboard-controls',
            mix: {
                block: 'b-api-management-cer-list',
                elem: 'app-moderation'
            },
            js: {
                id: 'cer-list-app-access'
            },
            content: {
                elem: 'popup',
                directions: ['left'],
                autoclosable: 'no',
                acceptButtonText: iget2('b-api-management-cer-list', 'izmenit-dostup', 'Изменить доступ'),
                innerBlock: applyCtx({
                    block: 'b-api-management-cert-moderation'
                })
            }
        }
    ];
});
