BEM.DOM.decl({ block: 'b-api-management-cer-list', modName: 'type', modVal: 'admin' }, {
    onSetMod: function() {
        this._request = BEM.create('i-request_type_ajax', {
            url: '/registered/main.pl',
            dataType: 'json',
            cache: false,
            callbackCtx: this
        });

        u.graspSelf.call(this, {
            _moderation: 'b-outboard-controls on moderation',
            _appModeration: 'b-outboard-controls on app-moderation'
        });

        this._moderation.on('accept', this._onAccept, this);
        this._appModeration.on('accept', this._onAppAccept, this);
    },

    /**
     * Колбек на подтверждения действия над заявкой
     * @param {jQuery.Event} e
     * @param {ApiRequestModerationAction} data заявка, над которой нужно совершить действие
     */
    _onAccept: function(e, data) {
        var errMsg = iget2(
            'b-api-management-cer-list',
            'obrabotat-zayavku-ne-udalos',
            'Обработать заявку не удалось. Серверная ошибка, обратитесь к разработчикам'
        );

        if (data.comment.length) {
            this._request.get({
                cmd: 'ajaxApiCertificationAddComment',
                application_id: data.application_id,
                comment: data.comment,
                ulogin: data.ulogin
            }, function() {
                this._request.get(
                    {
                        cmd: 'ajaxApiCertificationSetStatus',
                        application_id: data.application_id,
                        access_type: data.access_type,
                        ulogin: data.ulogin,
                        status: data.action
                    },
                    function() {
                        window.location.reload();
                    },
                    function() {
                        BEM.blocks['b-confirm'].alert(errMsg);
                    }
                );
            }, function() {
                BEM.blocks['b-confirm'].alert(errMsg);
            });
        } else {
            BEM.blocks['b-confirm'].alert(iget2('b-api-management-cer-list', 'vvedite-tekst-kommentariya', 'Введите текст комментария'));
        }
    },

    /**
     * Выполняет callback, если введен комментарий, иначе показывает алерт с ошибкой
     * @param {ApiRequestModerationAction} data заявка
     * @param {Function} callback
     */
    _ensureComment: function(data, callback) {
        if (data.comment.length) {
            callback.call(this);
        } else {
            BEM.blocks['b-confirm'].alert(iget2('b-api-management-cer-list', 'vvedite-tekst-kommentariya', 'Введите текст комментария'));
        }
    },

    /**
     * Колбек подтверждения изменения доступа приложения
     * @param {jQuery.Event} e
     * @param {ApiRequestModerationAction} data относящаяся к приложению заявка
     */
    _onAppAccept: function(e, data) {
        var actionToStatus = {
            disable: 'reject',
            enable: 'approve'
        };

        this._ensureComment(data, function() {
            this._request.get(
                {
                    cmd: 'ajaxApiAppSetStatus',
                    application_id: data.application_id,
                    access_type: data.access_type,
                    comment: data.comment,
                    ulogin: data.ulogin,
                    status: actionToStatus[data.action]
                },
                function() {
                    window.location.reload();
                },
                function() {
                    BEM.blocks['b-confirm'].alert(iget2(
                        'b-api-management-cer-list',
                        'obrabotat-zayavku-ne-udalos',
                        'Обработать заявку не удалось. Серверная ошибка, обратитесь к разработчикам'
                    ));
                });
        });
    }

});
