block('b-api-management-cer-list')(
    addJs()(true),

    content()(function() {
        var items = this.ctx.items || this.data.requests || [];

        items.forEach(function(item) {
            ['create_time', 'check_time', 'end_time'].forEach(function(key) {
                item[key] = u.formatDate(item[key]);
            });
        });

        return {
            elem: 'table',
            items: items
        };
    }),

    elem('table').content()(function() {
        var items = this.ctx.items.length ?
            this.ctx.items.map(function(item) {
                return {
                    block: 'b-cert-list-item',
                    hideEndTime: true,
                    data: item
                };
            }) :
            { elem: 'empty', content: iget2('b-api-management-cer-list', 'spisok-pust', 'список пуст') };

        return [
            {
                elem: 'header'
            },
            {
                elem: 'body',
                content: items
            }
        ];
    }),

    elem('header').content()(function() {
        return [
            {
                elem: 'title'
            },
            {
                block: 'dropdown',
                content: [
                    {
                        block: 'button',
                        mods: {
                            theme: 'normal'
                        },
                        mix: [
                            {
                                block: 'dropdown',
                                elem: 'switcher'
                            },
                            {
                                block: 'b-api-management-cer-list',
                                elem: 'new'
                            }
                        ],
                        content: iget2('b-api-management-cer-list', 'novaya-zayavka', 'Новая заявка')
                    },
                    {
                        elem: 'popup',
                        js: {
                            directions: 'bottom'
                        },
                        mix: {
                            block: 'b-api-management-cer-list',
                            elem: 'new-menu'
                        },
                        content: {
                            block: 'b-api-management-cer-list',
                            elem: 'new-menu'
                        }
                    }
                ]
            }
        ];
    }),

    elem('title').content()(function() {
        return iget2('b-api-management-cer-list', 'spisok-zayavok', 'Список заявок');
    }),

    elem('new-menu').def()(function() {
        return [
            {
                block: 'b-api-management-cer-list',
                elem: 'new-menu-item',
                elemMods: {
                    leader: 'yes'
                },
                url: u.getUrl('apiCertificationAddRequest', {
                    access_type: 'normal'
                }),
                content: iget2('b-api-management-cer-list', 'polnyy-dostup', 'Полный доступ')
            },
            {
                block: 'b-api-management-cer-list',
                elem: 'new-menu-item',
                url: u.getUrl('apiCertificationAddRequest', {
                    access_type: 'test'
                }),
                content: iget2('b-api-management-cer-list', 'testovyy-dostup', 'Тестовый доступ')
            }
        ];
    })
);
