BEM.DOM.decl('b-api-management-cer-list', {
    onSetMod: {
        js: function() {
            this._confirm = BEM.blocks['b-confirm'];

            BEM.blocks['b-cert-list-item'].on(this.domElem, 'delete', function(e, appId) {
                this._confirm.open({
                    message: iget2('b-api-management-cer-list', 'udalit-zayavku', 'Удалить заявку?'),
                    onYes: this._onDelete.bind(this, e.target, appId)
                });
            }, this);
        }
    },

    /**
     * Удаляет заявку.
     *
     * @private
     */
    _onDelete: function(target, appId) {
        var request = BEM.create(
            'i-request_type_ajax',
            {
                url: '/registered/main.pl',
                cache: false,
                dataType: 'json',
                callbackCtx: this,
                onError: this._showError.bind(this)
            }),
            requestParams = { cmd: 'ajaxCertificationDeleteRequest', application_id: appId };

        if (this.params.ulogin) requestParams.ulogin = this.params.ulogin;

        request.get(requestParams, function(data) { data.error ? this._showError() : this._deleteItem(target) });
    },

    _deleteItem: function(target) {
        target.destruct();

        var body = this.elem('body');

        body.children().length || BEM.DOM.append(
            body,
            BEMHTML.apply({ block: 'b-api-management-cer-list', elem: 'empty', content: iget2('b-api-management-cer-list', 'spisok-pust', 'список пуст') }));
    },

    /**
     * Показывает заявку.
     *
     * @private
     */
    _showError: function() {
        this._confirm.alert(iget2('b-api-management-cer-list', 'oshibka-zaprosa-poprobuyte-eshchyo', 'Ошибка запроса. Попробуйте ещё раз.'));
    }
});
