/**
 * Параметры заявки
 * @typedef {Object} ApiRequestModerationAction
 * @property {String} data.action действие над заявкой, approve или reject
 * @property {String} data.application_id id приложения из заявки
 * @property {String} data.ulogin логин пользователя, подавшего заявку
 * @property {String} data.comment комментарий к действию
 */

BEM.DOM.decl({ block: 'b-api-management-cert-moderation', implements: 'i-outboard-controls' }, {
    onSetMod: function() {
        this._comment = this.findBlockOn('comment', 'input');
        this._comment.on('change', function() {
            this._updateAcceptState();
        }, this);
    },

    /**
     * Обновляет состояние кнопки сохранения
     */
    _updateAcceptState: function() {
        this.trigger('state', { canSave: this._comment.val().length > 0 });
    },

    /**
     * @override {i-outboard-controls}
     * @param {ApiRequestModerationAction} data данные заявки, без комментария
     */
    prepareToShow: function(data) {
        var commentText = data.action === 'approve' ? iget2('b-api-management-cert-moderation', 'zayavka-odobrena', 'Заявка одобрена.') : '';

        this._comment.val(commentText);
        this._updateAcceptState();

        this._requestData = {
            application_id: data.application_id,
            ulogin: data.ulogin,
            app_access: data.app_access,
            action: data.action,
            access_type: data.access_type
        };
    },

    /**
     * @override {i-outboard-controls}
     * @returns {ApiRequestModerationAction} параметры заявки
     */
    provideData: function() {
        this._requestData.comment = this._comment.val();

        return this._requestData;
    },

    /**
     * @override {i-outboard-controls}
     */
    declineChange: function() {
        //ничего не делаем
    }

});
