block('b-api-management-finance-settings')(
    addJs()(true),

    content()(function() {
        var lang = this.data.lang,
            techDomain = (lang == 'en' || lang == 'tr') ? 'com' : 'ru';

        return [
            {
                elem: 'title',
                content: iget2('b-api-management-finance-settings', 'finansovye-operacii', 'Финансовые операции')
            },
            !!this.data.error && {
                elem: 'error',
                content: this.data.error
            },
            {
                block: 'b-layout-form',
                mix: [{
                    block: 'b-api-management-finance-settings',
                    elem: 'form'
                }],

                mixes: {
                    label: [{
                        block: 'b-api-management-finance-settings',
                        elem: 'form-label'
                    }],
                    control: [{
                        block: 'b-api-management-finance-settings',
                        elem: 'form-control'
                    }]
                },

                action: this.data.SCRIPT,

                hiddenInputs: [
                    {
                        name: 'ulogin',
                        value: u.escapeHTML(this.data.FORM.ulogin || this.data.user_login || this.data.uname)
                    },
                    {
                        name: 'cmd',
                        value: 'saveApiFinanceSettings'
                    },
                    {
                        name: 'api_allow_finance_operations',
                        value: ''
                    },
                    {
                        name: 'api_send_mail_notifications',
                        value: ''
                    }
                ],

                submit: {
                    block: 'button',
                    mix: [{
                        block: 'b-api-management-finance-settings',
                        elem: 'form-save'
                    }],
                    type: 'submit',
                    content: iget2('b-api-management-finance-settings', 'sohranit-izmeneniya', 'Сохранить изменения')
                },

                rows: [
                    {
                        label: iget2('b-api-management-finance-settings', 'obshchie-nastroyki', 'Общие настройки') + ':',
                        control: [
                            {
                                block: 'checkbox',
                                mix: [{
                                    block: 'b-api-management-finance-settings',
                                    elem: 'form-checkbox'
                                }],
                                mods: {
                                    checked: this.data.api_allow_finance_operations ? 'yes' : ''
                                },
                                checkboxAttrs: {
                                    value: '1',
                                    name: 'api_allow_finance_operations'
                                },
                                text: iget2('b-api-management-finance-settings', 'razreshit-finansovye-operacii', 'Разрешить финансовые операции')
                            },
                            {
                                block: 'checkbox',
                                mix: [{
                                    block: 'b-api-management-finance-settings',
                                    elem: 'form-checkbox'
                                }],
                                mods: {
                                    checked: this.data.api_send_mail_notifications ? 'yes' : ''
                                },
                                checkboxAttrs: {
                                    value: '1',
                                    name: 'api_send_mail_notifications'
                                },
                                text: iget2(
                                    'b-api-management-finance-settings',
                                    'otpravlyat-uvedomleniya-po-email',
                                    'Отправлять уведомления по email при работе с фин. операциями'
                                )
                            }
                        ]
                    }
                ]
            },
            {
                elem: 'security-message',
                content: iget2(
                    'b-api-management-finance-settings',
                    'dlya-povysheniya-bezopasnosti-perenos',
                    'Для повышения безопасности, перенос средств, выставление счетов и другие финансовые операции могут осуществляться сторонней программой только при наличии мастер-токена.'
                )
            },
            {
                elem: 'security-link',
                content: iget2('b-api-management-finance-settings', 'podrobnoe-opisanie-dostupno-v', 'Подробное описание доступно в {link}.', {
                    link: function(text) {
                        return {
                            block: 'link',
                            url: u.formatUrl({
                                protocol: 'https',
                                host: 'tech.yandex.' + techDomain,
                                path: '/direct/'
                            }),
                            attrs: {
                                target: '_blank'
                            },
                            content: text
                        };
                    }(iget2(
                        'b-api-management-finance-settings',
                        'podrobnoe-opisanie-dostupno-v-param-link',
                        'документации для разработчиков API Яндекс.Директа'
                    )),

                    context: 'link - документации для разработчиков API Яндекс.Директа'
                })
            },
            {
                elem: 'master-token',
                content: [
                    {
                        elem: 'title',
                        content: [
                            iget2('b-api-management-finance-settings', 'master-token', 'Мастер-токен'),
                            parseInt(this.data.master_token_timecreated) > 0 && {
                                block: 'b-api-management-finance-settings',
                                elem: 'master-token-created-time',
                                content: ' ' + iget2('b-api-management-finance-settings', 'byl-vypisan-time', '(был выписан {time})', {
                                    time: u.moment(this.data.master_token_timecreated).format('DD.MM.YYYY')
                                })
                            }
                        ]
                    },
                    {
                        elem: 'confirmed-action',
                        cmd: 'getMasterToken',
                        message: iget2('b-api-management-finance-settings', 'vy-uvereny-chto-hotite', 'Вы уверены, что хотите выписать новый мастер-токен?'),
                        caption: iget2('b-api-management-finance-settings', 'vypisat-novyy-master-token', 'Выписать новый мастер-токен')
                    },
                    {
                        elem: 'confirmed-action',
                        cmd: 'dropMasterToken',
                        message: iget2('b-api-management-finance-settings', 'vy-uvereny-chto-hotite-111', 'Вы уверены, что хотите сбросить мастер-токен?'),
                        caption: iget2('b-api-management-finance-settings', 'sbrosit-master-token', 'Сбросить мастер-токен')
                    }
                ]
            },
            {
                elem: 'operations-counter',
                content: [
                    {
                        elem: 'title',
                        content: [
                            iget2('b-api-management-finance-settings', 'schyotchik-finansovyh-operaciy', 'Счётчик финансовых операций'),
                            parseInt(this.data.finance_cnt_dropped_time) > 0 && {
                                block: 'b-api-management-finance-settings',
                                elem: 'operations-counter-dropped-count',
                                content: ' ' + iget2('b-api-management-finance-settings', 'byl-sbroshen-time', '(был сброшен {time})', {
                                    time: u.moment(this.data.finance_cnt_dropped_time).format('DD.MM.YYYY')
                                })
                            }
                        ]
                    },
                    {
                        elem: 'confirmed-action',
                        cmd: 'dropFinanceOpsCounter',
                        message: iget2('b-api-management-finance-settings', 'vy-uvereny-chto-hotite-112', 'Вы уверены, что хотите сбросить значение счётчика?'),
                        caption: iget2('b-api-management-finance-settings', 'sbrosit-znachenie-schyotchika', 'Сбросить значение счётчика')
                    }
                ]
            }
        ];
    }),

    elem('confirmed-action').content()(function() {
        return {
            block: 'b-layout-form',
            mix: [
                {
                    block: 'i-form',
                    mods: {
                        submit: 'bem-event'
                    }
                },
                {
                    block: 'b-api-management-finance-settings',
                    elem: 'confirm',
                    js: {
                        message: this.ctx.message
                    }
                }
            ],
            action: this.data.SCRIPT,
            hiddenInputs: [
                {
                    name: 'cmd',
                    value: this.ctx.cmd
                },
                {
                    name: 'ulogin',
                    value: u.escapeHTML(this.data.FORM.ulogin || this.data.user_login || this.data.uname)
                }
            ],
            submit: {
                block: 'button',
                type: 'submit',
                content: this.ctx.caption
            }
        };
    })
);
