block('b-api-management-sandbox')(
    addJs()(function() {
        var currenciesDescription = u.consts('currencies'),
            currencies = Object.keys(currenciesDescription).reduce(function(acc, key) {
                acc[key] = currenciesDescription[key].full_name;
                return acc;
            }, {});

        return {
            currencies: currencies
        };
    }),

    match(function() {
        return !this.ctx.mods || !this.ctx.mods.section;
    }).wrap()(function() {
        this.ctx.mods = this.ctx.mods || {};
        this.ctx.mods.section = (this.data.current_sandbox_state && this.data.current_sandbox_state.role != 'empty') ?
            'content' :
            'intro';

        return this.ctx;
    }),

    content()(function() {
        var currentSandboxState = this.data.current_sandbox_state || {},
            currenciesDescription = u.consts('currencies'),
            currenciesOrder = u.consts('currencies_order').filter(function(el) {
                return el !== 'YND_FIXED' && el !== 'GBP' && currenciesDescription[el]
            }),
            currencies = currenciesOrder.reduce(function(acc, el) {
                acc[el] = {
                    full_name: currenciesDescription[el].full_name
                };

                return acc;
            }, {}),
            currentCurrency = currencies[currentSandboxState.currency],
            currentRole = currentSandboxState.role || 'client';

        if (currentRole === 'empty') currentRole = 'client';

        return this.data.api_offer == 'accepted' && [
            {
                elem: 'title',
                content: iget2('b-api-management-sandbox', 'pesochnica', 'Песочница')
            },
            {
                elem: 'description',
                content: iget2(
                    'b-api-management-sandbox',
                    'laquo-pesochnica-raquo-nbsp',
                    '&laquo;Песочница&raquo;&nbsp;&mdash; это тестовая среда, обладающая полной функциональностью API Яндекс.Директа, но&nbsp;работающая с&nbsp;&laquo;игрушечными&raquo; рекламными кампаниями. Здесь Вы можете отлаживать свои программы, не&nbsp;рискуя случайно что-нибудь сломать.'
                )
            },
            {
                elem: 'sandbox',
                content: [
                    {
                        elem: 'intro',
                        content: [
                            {
                                block: 'link',
                                mix: [{
                                    block: 'b-api-management-sandbox',
                                    elem: 'begin-use-sandbox'
                                }],
                                mods: {
                                    pseudo: 'yes'
                                },
                                content: iget2('b-api-management-sandbox', 'nachat-polzovatsya-pesochnicey', 'Начать пользоваться песочницей')
                            },
                            {
                                block: 'popup',
                                mix: [{
                                    block: 'b-api-management-sandbox',
                                    elem: 'begin-use-sandbox-popup'
                                }],
                                mods: {
                                    position: 'fixed',
                                    type: 'modal',
                                    autoclosable: 'no',
                                    'body-scroll': 'no'
                                },
                                underMods: {
                                    type: 'paranja'
                                },
                                content: [
                                    {
                                        elem: 'close'
                                    },
                                    {
                                        elem: 'content',
                                        content: {
                                            block: 'b-api-management-sandbox',
                                            elem: 'activate-form-container',
                                            content: [
                                                {
                                                    elem: 'activate-form-title',
                                                    content: iget2('b-api-management-sandbox', 'sozdanie-laquo-pesochnicy-raquo', 'Создание &laquo;Песочницы&raquo;')
                                                },
                                                {
                                                    block: 'b-layout-form',
                                                    mix: [
                                                        {
                                                            block: 'i-form',
                                                            mods: {
                                                                submit: 'bem-event'
                                                            }
                                                        },
                                                        {
                                                            block: 'b-api-management-sandbox',
                                                            elem: 'activate-form'
                                                        }
                                                    ],
                                                    mixes: {
                                                        label: [{
                                                            block: 'b-api-management-sandbox',
                                                            elem: 'activate-form-label'
                                                        }],
                                                        control: [{
                                                            block: 'b-api-management-sandbox',
                                                            elem: 'activate-form-control'
                                                        }]
                                                    },
                                                    rows: [
                                                        {
                                                            label: iget2('b-api-management-sandbox', 'rol', 'Роль') + ':',
                                                            control: {
                                                                block: 'radiobox',
                                                                mix: [{
                                                                    block: 'b-api-management-sandbox',
                                                                    elem: 'activate-form-role'
                                                                }],
                                                                name: 'sandbox_client_type',
                                                                value: currentRole,
                                                                content: [
                                                                    {
                                                                        elem: 'radio',
                                                                        content: iget2('b-api-management-sandbox', 'klient', 'Клиент'),
                                                                        controlAttrs: {
                                                                            value: 'client'
                                                                        }
                                                                    },
                                                                    '&nbsp;&nbsp;',
                                                                    {
                                                                        elem: 'radio',
                                                                        content: iget2('b-api-management-sandbox', 'agentstvo', 'Агентство'),
                                                                        controlAttrs: {
                                                                            value: 'agency'
                                                                        }
                                                                    }
                                                                ]
                                                            }
                                                        },
                                                        {
                                                            label: iget2('b-api-management-sandbox', 'valyuta', 'Валюта') + ':',
                                                            control: {
                                                                block: 'select',
                                                                mix: [{
                                                                    block: 'b-api-management-sandbox',
                                                                    elem: 'currency_choose'
                                                                }],
                                                                name: 'currency',
                                                                content: [
                                                                    {
                                                                        block: 'button',
                                                                        content: ''
                                                                    },
                                                                    {
                                                                        elem: 'control',
                                                                        content: currenciesOrder.map(function(key) {
                                                                            return {
                                                                                elem: 'option',
                                                                                attrs: {
                                                                                    value: key,
                                                                                    selected: undefined
                                                                                },
                                                                                // DIRECT-40209
                                                                                // нужно оборачивать в iget в шаблоне,
                                                                                // в модуле он обернут iget_noop()
                                                                                content: iget2('common-i18n', currencies[key].full_name)
                                                                            };
                                                                        })
                                                                    }
                                                                ]
                                                            }
                                                        },
                                                        {
                                                            label: '&nbsp;',
                                                            control: {
                                                                block: 'checkbox',
                                                                mix: [{
                                                                    block: 'b-api-management-sandbox',
                                                                    elem: 'activate-form-test-data'
                                                                }],
                                                                checkboxAttrs: {
                                                                    value: '1',
                                                                    name: 'init_test_data'
                                                                },
                                                                text: iget2('b-api-management-sandbox', 'sozdat-testovye-kampanii', 'Создать тестовые кампании')
                                                            }
                                                        },
                                                        {
                                                            label: '&nbsp;',
                                                            control: {
                                                                block: 'checkbox',
                                                                mix: [{
                                                                    block: 'b-api-management-sandbox',
                                                                    elem: 'activate-form-os'
                                                                }],
                                                                checkboxAttrs: {
                                                                    value: '1',
                                                                    name: 'enable_shared_account'
                                                                },
                                                                text: iget2('b-api-management-sandbox', 'obshchiy-schyot', 'Общий счёт')
                                                            }
                                                        }
                                                    ],
                                                    submit: {
                                                        block: 'b-api-management-sandbox',
                                                        elem: 'activate-form-controls',
                                                        content: [
                                                            {
                                                                block: 'button',
                                                                mix: [{
                                                                    block: 'b-api-management-sandbox',
                                                                    elem: 'activate-form-submit'
                                                                }],
                                                                type: 'submit',
                                                                content: iget2('b-api-management-sandbox', 'prodolzhit', 'Продолжить')
                                                            },
                                                            {
                                                                block: 'button',
                                                                mix: [{
                                                                    block: 'b-api-management-sandbox',
                                                                    elem: 'activate-form-cancel'
                                                                }],
                                                                content: iget2('b-api-management-sandbox', 'otmena', 'Отмена')
                                                            }
                                                        ]
                                                    }
                                                }
                                            ]
                                        }
                                    }
                                ]
                            }
                        ]
                    },
                    {
                        elem: 'content',
                        content: {
                            block: 'b-layout-form',
                            mods: {
                                'auto-append-colons': 'yes'
                            },
                            mixes: {
                                label: [{
                                    block: 'b-api-management-sandbox',
                                    elem: 'label'
                                }],
                                control: [{
                                    block: 'b-api-management-sandbox',
                                    elem: 'control'
                                }]
                            },
                            rows: [
                                {
                                    label: iget2('b-api-management-sandbox', 'rol', 'Роль'),
                                    control: {
                                        block: 'radiobox',
                                        mix: [{
                                            block: 'b-api-management-sandbox',
                                            elem: 'role'
                                        }],
                                        name: 'sandbox_client_type',
                                        value: currentRole,
                                        content: [
                                            {
                                                elem: 'radio',
                                                content: iget2('b-api-management-sandbox', 'klient', 'Клиент'),
                                                controlAttrs: {
                                                    value: 'client'
                                                }
                                            },
                                            '&nbsp;&nbsp;&nbsp;&nbsp;',
                                            {
                                                elem: 'radio',
                                                content: iget2('b-api-management-sandbox', 'agentstvo', 'Агентство'),
                                                controlAttrs: {
                                                    value: 'agency'
                                                }
                                            }
                                        ]
                                    }
                                },
                                {
                                    label: iget2('b-api-management-sandbox', 'valyuta', 'Валюта'),
                                    control: {
                                        block: 'b-api-management-sandbox',
                                        elem: 'currency',
                                        // DIRECT-46742
                                        // нужно оборачивать в iget в шаблоне,
                                        // в модуле он обернут iget_noop()
                                        content: currentCurrency && iget2('common-i18n', currentCurrency.full_name)
                                    }
                                },
                                {
                                    label: iget2('b-api-management-sandbox', 'obshchiy-schyot', 'Общий счёт'),
                                    control: {
                                        block: 'b-api-management-sandbox',
                                        elem: 'shared_account',
                                        content: currentSandboxState.shared_account_enabled ? iget2('b-api-management-sandbox', 'vklyuchen', 'включен') : iget2('b-api-management-sandbox', 'vyklyuchen', 'выключен')
                                    }
                                },
                                {
                                    label: iget2('b-api-management-sandbox', 'master-token', 'Мастер-токен'),
                                    control: {
                                        block: 'b-api-management-sandbox',
                                        elem: 'master-token',
                                        content: currentSandboxState.master_token
                                    }
                                },
                                {
                                    label: iget2('b-api-management-sandbox', 'upravlenie', 'Управление'),
                                    control: {
                                        block: 'b-api-management-sandbox',
                                        elem: 'control-links-list',
                                        content: [
                                            {
                                                action: 'camp',
                                                caption: iget2('b-api-management-sandbox', 'sozdat-testovye-kampanii', 'Создать тестовые кампании')
                                            },
                                            {
                                                action: 'clear',
                                                caption: iget2('b-api-management-sandbox', 'ochistit-laquo-pesochnicu-raquo', 'Очистить &laquo;Песочницу&raquo;')
                                            },
                                            {
                                                action: 'counter',
                                                caption: iget2('b-api-management-sandbox', 'sbrosit-schyotchik-finansovyh-operaciy', 'Сбросить счётчик финансовых операций')
                                            },
                                            {
                                                action: 'drop',
                                                caption: iget2('b-api-management-sandbox', 'perestat-polzovatsya-laquo-pesochnicey', 'Перестать пользоваться &laquo;Песочницей&raquo;')
                                            }
                                        ].map(function(link) {
                                            return {
                                                block: 'link',
                                                mix: [{
                                                    block: 'b-api-management-sandbox',
                                                    elem: 'control-link',
                                                    elemMods: {
                                                        action: link.action
                                                    }
                                                }],
                                                url: '#',
                                                content: link.caption
                                            };
                                        })
                                    }
                                }
                            ]
                        }
                    }
                ]
            },
            {
                block: 'popup',
                mix: [{
                    block: 'b-api-management-sandbox',
                    elem: 'spinner-popup'
                }],
                mods: {
                    type: 'modal',
                    position: 'fixed',
                    autoclosable: 'no'
                },
                underMods: {
                    type: 'paranja'
                },
                content: {
                    block: 'b-api-management-sandbox',
                    elem: 'spinner',
                    content: [
                        {
                            block: 'spin',
                            mix: [{
                                block: 'b-api-management-sandbox',
                                elem: 'spinner-icon'
                            }],
                            js: true,
                            mods: {
                                progress: 'yes'
                            }
                        },
                        {
                            block: 'b-api-management-sandbox',
                            elem: 'spinner-content',
                            content: iget2('b-api-management-sandbox', 'pozhaluysta-podozhdite', 'Пожалуйста, подождите')
                        }
                    ]
                }
            }
        ];

    })
);
