BEM.DOM.decl('b-api-management-sandbox', {
    onSetMod: {
        status: function(modName, modVal) {
            this.setMod(this.spinnerPopupElem, modName, modVal);

            if (modVal == 'busy') {
                this.spinnerContent.html(iget2('b-api-management-sandbox', 'podozhdite-pozhaluysta', 'Подождите, пожалуйста'));
                this.spinnerPopup.show();
            } else if (modVal === 'reinit') {
                this.spinnerPopup.hide();
            } else {
                setTimeout(function() {
                    this.spinnerPopup.hide();
                }.bind(this), 2000);
            }
        },
        js: function() {
            u.graspSelf.call(this, {
                activateSandbox: 'link on begin-use-sandbox',
                activateSandboxPopup: 'popup on begin-use-sandbox-popup',
                activateForm: 'i-form on activate-form',
                activateFormCancel: 'button on activate-form-cancel',
                activateFormRole: 'radiobox on activate-form-role',
                activateFormTestData: 'checkbox on activate-form-test-data',
                activateFormOs: 'checkbox on activate-form-os',
                currencyChoose: 'select on currency_choose',
                masterToken: 'master-token',
                role: 'radiobox on role',
                spinnerContent: 'spinner-content',
                spinnerPopup: 'popup on spinner-popup',
                spinnerPopupElem: 'spinner-popup'
            });

            this._request = BEM.create('i-request_type_ajax', {
                url: '/registered/main.pl',
                callbackCtx: this,
                cache: false,
                timeout: 120000,
                dataType: 'json',
                onError: function() {
                    BEM.blocks['b-confirm'].alert(iget2('b-api-management-sandbox', 'oshibka-zaprosa-poprobuyte-eshchyo', 'Ошибка запроса. Попробуйте ещё раз.'));
                    this.delMod('status');
                }
            });

            this._initIntro();
            this._initContent();
        }
    },

    /**
     * Отправляет запрос на изменение песочницы и обновляет интерфейс по результатам запроса
     * @param {Object} data данные запроса
     * @param {String} successMessage сообщение, отображаемое при успешном запросе
     * @param {Function} successCallback колбек при успешном запросе
     */
    _doRequest: function(data, successMessage, successCallback) {
        this.setMod('status', 'busy');
        this._request.get(data, function(data) {
            if (!data.error) {
                successMessage && this.spinnerContent.html(successMessage);
                this.masterToken.html(data.current_sandbox_state.master_token);

                this.isUpdateVisuals = true;
                this.role.val(data.current_sandbox_state.role);
                this.isUpdateVisuals = false;

                this.setMod('status', successMessage ? '' : 'reinit');

                successCallback && successCallback.call(this, data);
            } else {
                this.setMod('status', '');
                BEM.blocks['b-confirm'].alert(data.error);
            }
        });
    },

    /**
     * Инициализирует форму создания песочницы
     */
    _initIntro: function() {
        var activateFormOs = this.activateFormOs,
            activateFormTestData = this.activateFormTestData,
            activateFormRole = this.activateFormRole;

        this._roleValue = activateFormRole.val();

        this.activateSandbox.on('click', function() {
            this.activateSandboxPopup.show();
        }, this);

        this.activateFormCancel.on('click', function() {
            this.activateSandboxPopup.hide();
        }, this);

        activateFormRole.on('change', function() {
            var newRole = this._roleValue = activateFormRole.val(),
                isAgency = newRole === 'agency';

            if (isAgency) {
                activateFormOs.setMod('checked', '');
            }

            activateFormOs.setMod('disabled', isAgency ? 'yes' : '');

        }, this);

        activateFormOs.on('change', function() {
            var isChecked = this.isChecked();

            if (isChecked) {
                activateFormTestData.setMod('checked', 'yes');
            }

            activateFormTestData.setMod('disabled', isChecked ? 'yes' : '');
        });

        this.activateForm.on('submit', function(e) {
            this._doRequest(
                {
                    cmd: 'ajaxInitSandboxUser',
                    sandbox_client_type: this.activateFormRole.val(),
                    init_test_data: +this.activateFormTestData.isChecked(),
                    initial_currency: this.currencyChoose.val(),
                    enable_shared_account: +this.activateFormOs.isChecked()
                },
                iget2('b-api-management-sandbox', 'pesochnica-uspeshno-sozdana', 'Песочница успешно создана.'),
                function(res) {
                    this.elem('currency').html(this.params.currencies[res.current_sandbox_state.currency]);
                    this.elem('shared_account').html(
                        res.current_sandbox_state.shared_account_enabled ?
                            iget2('b-api-management-sandbox', 'vklyuchen', 'включен') :
                            iget2('b-api-management-sandbox', 'vyklyuchen', 'выключен'));

                    this.setMod('section', 'content');
                }
            );

            this.activateSandboxPopup.hide();
        }, this);
    },

    /**
     * Инициализирует форму редактирования песочницы
     */
    _initContent: function() {
        var actionsParams = {
            camp: {
                question: iget2(
                    'b-api-management-sandbox',
                    'pri-sozdanii-testovyh-dannyh',
                    'При создании тестовых данных будет удалена вся созданная Вами информация в Песочнице.'
                ),
                requestParams: function() {
                    return {
                        cmd: 'ajaxInitSandboxUser',
                        sandbox_client_type: this.role.val(),
                        init_test_data: 1
                    }
                },
                successMessage: iget2('b-api-management-sandbox', 'sozdany-testovye-dannye', 'Созданы тестовые данные.')
            },
            clear: {
                question: iget2('b-api-management-sandbox', 'vy-deystvitelno-hotite-udalit', 'Вы действительно хотите удалить все данные из Песочницы?'),
                requestParams: function() {
                    return {
                        cmd: 'ajaxInitSandboxUser',
                        sandbox_client_type: this.role.val(),
                        init_test_data: 0
                    }
                },
                successMessage: iget2('b-api-management-sandbox', 'iz-pesochnicy-udaleny-vse', 'Из песочницы удалены все данные.')
            },
            counter: {
                question: iget2(
                    'b-api-management-sandbox',
                    'obnulit-znachenie-schyotchika-finansovyh',
                    'Обнулить значение счётчика финансовых операций в Песочнице?'
                ),
                requestParams: function() {
                    return {
                        cmd: 'ajaxDropSandboxFinanceOpsCounter'
                    };
                },
                successMessage: iget2('b-api-management-sandbox', 'znachenie-schyotchika-obnuleno', 'Значение счётчика обнулено')
            },
            drop: {
                question: iget2(
                    'b-api-management-sandbox',
                    'vy-deystvitelno-hotite-perestat',
                    'Вы действительно хотите перестать пользоваться Песочницей и удалить всю созданную в ней информацию?'
                ),
                requestParams: function() {
                    return {
                        cmd: 'ajaxDropSandboxUser'
                    };
                },
                successMessage: iget2('b-api-management-sandbox', 'pesochnica-zakryta', 'Песочница закрыта'),
                successCallback: function() {
                    this.setMod('section', 'intro');
                }
            }
        };

        this.bindTo('control-link', 'click', function(e) {
            var action = this.getMod(e.data.domElem, 'action'),
                params = actionsParams[action];

            BEM.blocks['b-confirm'].open({
                type: 'confirm',
                message: params.question,
                onYes: function() {
                    this._doRequest(params.requestParams.call(this), params.successMessage, params.successCallback)
                }.bind(this)
            });

            e.preventDefault();
        });

        this.role.on('change', function() {
            var newRole = this.role.val();

            if (!this.isUpdateVisuals && newRole != this._roleValue) {
                BEM.blocks['b-confirm'].open({
                    message: iget2(
                        'b-api-management-sandbox',
                        'pri-izmenenii-roli-testovogo',
                        'При изменении роли тестового логина будет удалена вся созданная Вами информация в Песочнице. Вы действительно хотите изменить роль?'
                    ),
                    onYes: function() {
                        var params = actionsParams.drop;

                        this._roleValue = newRole;

                        this._doRequest(params.requestParams.call(this), null, function() {
                            params.successCallback.call(this);
                            this.activateFormRole.val(newRole);
                            this.activateSandboxPopup.show();
                        }.bind(this));
                    }.bind(this),
                    onNo: function() {
                        this.role.val(this._roleValue);
                    }.bind(this)
                });
            }
        }, this);
    }
});
