block('b-api-management-settings').content()(function() {
    var data = this.data,
        apiList = data.api_allowed_ips ? data.api_allowed_ips.split(',') : [];

    apiList = apiList.map(function(item) {
        var splited = item.split('/');

        return {
            id: this.identify(),
            ip: splited[0],
            mask: splited[1]
        };
    }, this);

    var content = [
        {
            block: 'b-api-management',
            elem: 'title',
            content: iget2(
                'b-api-management-settings',
                'koordinaty-tehnicheskogo-specialista-po',
                'Координаты технического специалиста по работе с API Директа'
            )
        },
        !!data.error && {
            block: 'b-api-management',
            elem: 'error',
            content: data.error
        },
        {
            block: 'b-api-management-settings',
            elem: 'content',
            content: [
                {
                    block: 'b-api-management',
                    elem: 'row',
                    content: [
                        {
                            elem: 'field-label',
                            content: iget2('b-api-management-settings', 'kontaktnoe-lico', 'Контактное лицо') + ':'
                        },
                        {
                            elem: 'field-content',
                            content: {
                                block: 'input',
                                name: 'api_developer_name',
                                value: data.api_developer_name || '',
                                content: {
                                    elem: 'control'
                                }
                            }
                        }
                    ]
                },
                {
                    block: 'b-api-management',
                    elem: 'row',
                    content: [
                        {
                            elem: 'field-label',
                            content: iget2('b-api-management-settings', 'el-pochta', 'Эл. почта') + ':'
                        },
                        {
                            elem: 'field-content',
                            content: {
                                block: 'input',
                                name: 'api_developer_email',
                                value: data.api_developer_email || '',
                                content: {
                                    elem: 'control'
                                }
                            }
                        }
                    ]
                },
                {
                    block: 'b-api-management',
                    elem: 'row',
                    elemMods: {
                        'with-padding': 'yes'
                    },
                    content: [
                        {
                            elem: 'field-label',
                            content: iget2('b-api-management-settings', 'razreshennye-ip-adresa', 'Разрешенные IP-адреса') + ':'
                        },
                        {
                            elem: 'field-content',
                            content: {
                                block: 'b-ip-list',
                                js: true,
                                items: apiList
                            }
                        }
                    ]
                },
                {
                    block: 'b-api-management',
                    elem: 'row',
                    elemMods: {
                        'with-padding': 'yes',
                        'empty-label': 'yes'
                    },
                    content: [
                        {
                            block: 'button',
                            js: {
                                action: 'save'
                            },
                            attrs: {
                                type: 'submit'
                            },
                            content: iget2('b-api-management-settings', 'sohranit-izmeneniya', 'Сохранить изменения')
                        }
                    ]
                }
            ]
        }
    ];

    return {
        block: 'b-api-management',
        elem: 'form',
        mix: {
            block: 'i-glue',
            js: {
                modelParams: {
                    name: 'm-ip-list',
                    data: {
                        items: apiList,
                        apiAllowedIps: data.api_allowed_ips
                    }
                }
            }
        },
        content: [
            {
                block: 'b-hidden',
                js: false,
                name: 'cmd',
                value: 'saveApiSettings'
            },
            !!data.FORM.ulogin && {
                block: 'b-hidden',
                js: false,
                name: 'ulogin',
                value: data.FORM.ulogin
            },
            {
                block: 'b-hidden',
                js: false,
                name: 'api_allowed_ips',
                value: data.api_allowed_ips || '',
                mix: {
                    block: 'i-glue',
                    elem: 'model-field',
                    js: {
                        name: 'apiAllowedIps',
                        type: 'native'
                    }
                }
            },
            content
        ],
        tag: 'form',
        attrs: {
            action: data.SCRIPT
        }
    };
});
