/**
 * Форма создания/редактирования условия
 *
 * @param {String} modelName
 * @param {String} modelId
 */
BEM.DOM.decl('b-audience-selection', {

    /**
     * Модель ретаргетинга (dm-retargeting)
     */
    _model: null,

    /**
     * Менеджер подписок
     */
    _subMan: null,

    /**
     * Блок с названием условия
     */
    _label: null,

    onSetMod: {
        js: function() {
            this._model = BEM.MODEL.getOne({
                name: this.params.modelName,
                id: this.params.modelId
            });

            this._subMan = BEM.create('i-subscription-manager');

            this._label = this.findBlockInside('name', 'b-editable-label');

            this._initEvents();

            this._drawSegmentTypeBlocks();
        }
    },

    /**
     * Возвращает используемую модель
     */
    getModel: function() {
        return this._model;
    },

    /**
     * Валидирует модель, показывает ошибки в невалидных блоках
     */
    showErrors: function() {
        var conditionNameErrors = this._model.fields.condition_name.validate();

        // Метод 'validate' возвращает объект с ошибками иначе 'true'
        if (typeof conditionNameErrors == 'object') {
            this._label.showError(conditionNameErrors.invalidRules[0].text);
        }
    },

    /**
     * Спрятать ошибки
     */
    clearErrors: function() {
        this._label.hidePopup();  // чтобы не прыгал tipman из-за скрытия ошибок в родительском блоке
    },

    /**
     * Подписка на события
     */
    _initEvents: function() {
        this._subMan
            .on(this._label, 'change', function(e, data) {
                this._model.set('condition_name', data.value);
                this.showErrors();  // после сохранения значения полученного от инпута нужно его провалидировать и показать ошибку
            }, this)
            .on(this._model, 'condition_name', 'change', function(e, data) {
                this._label.setValue(data.value);
            }, this);

        this._label.setValue(this._model.get('condition_name') || iget2('b-audience-selection', 'novaya-auditoriya', 'Новая аудитория'))
    },

    /**
     * Отрисовывает блоки `b-segments-group`
     * @private
     */
    _drawSegmentTypeBlocks: function() {
        var openedGroup = this._calculateOpenedGroup();

        ['social-demo', 'family', 'behaviors', 'interests', 'metrika', 'audio-genres'].forEach(function(key) {
            this._drawSegmentTypeBlock({
                type: key,
                groups: this._model.get(key)
            }, openedGroup === key);
        }, this);

    },

    /**
     * Отрисовывает блок сегментов
     * @param {Object} data
     * @param {CryptaType} data.type - тип группы сегментов
     * @param {Array<RetConditionGroup>} data.groups
     * @param {Boolean} isOpen - открыт сегмент или нет
     * @private
     */
    _drawSegmentTypeBlock: function(data, isOpen) {
        BEM.DOM.append(this.elem('body'), BEMHTML.apply({
            block: 'b-segments-group',
            mods: {
                type: data.type,
                open: isOpen ? 'yes' : ''
            },
            groups: data.groups
        }));
    },

    /**
     * Расчитывает, какую группу открыть по-умолчанию после создания формы
     * @returns {String}
     * @private
     */
    _calculateOpenedGroup: function() {
        var groupsPriorityOrder = ['social-demo', 'family', 'behaviors', 'interests', 'metrika', 'audio-genres'];

        return u._.find(groupsPriorityOrder, function(group) {
            return this._model.get(group).length > 0;
        }, this) || groupsPriorityOrder[0];
    },

    /**
     * Обработчик изменения формы
     * @param {Event} e
     * @param {Object} data - данные события
     * @param {'socdemo'|'family'|'metrika'} data.type - тип
     * @param {Array<RetConditionGroup>} data.groups - формула
     * @private
     */
    _onSegmentsChanged: function(e, data) {
        this._model.set(data.type, data.groups);
    },

    /**
     * Обработчик изменения списка недоступных целей
     * @param {Event} e
     * @param {Array} data - данные события
     * @private
     */
    _onSegmentsForbidUse: function(e, data) {
        this._model.set('forbidToUse', data);
    },

    destruct: function() {
        this._subMan.dispose();
        this.__base.apply(this, arguments);
    }

}, {

    live: function() {

        this.liveInitOnBlockInsideEvent('change forbid-to-use', 'b-segments-group', function(e, data) {
            e.type === 'change' && this._onSegmentsChanged(e, data);
            e.type === 'forbid-to-use' && this._onSegmentsForbidUse(e, data);
        });

        return false;
    }
});
