block('b-autobudget-media-form')(
    js()(true),

    def().match(function() {
        return this.ctx.isEditable;
    })(function() {
        return applyNext({
            'mods.disabled': this.ctx.campaign.autobudget ? '' : 'yes'
        });
    }),

    content()(function() {
        var campaign = this.ctx.campaign,
            autobubget = campaign.autobudget;

        return [
            {
                block: 'checkbox',
                mods: {
                    disabled: this.ctx.isEditable ? undefined : 'yes',
                    checked: autobubget ? 'yes' : ''
                },
                checkboxAttrs: {
                    name: 'autobudget',
                    value: 'Yes'
                },
                text: {
                    mix: {
                        block: 'b-autobudget-media-form',
                        elem: 'label'
                    },
                    content: iget2('b-autobudget-media-form', 'staratsya-raspredelit-pokazy-do', 'Стараться распределить показы до')
                }
            },
            '&nbsp',
            {
                block: 'b-date-input',
                mix: [{
                    block: 'b-autobudget-media-form',
                    elem: 'input'
                }],
                mods: {
                    disabled: this.ctx.isEditable && autobubget ? undefined : 'yes'
                },
                name: 'autobudget_date',
                value: campaign.autobudget_date,
                dateFormat: 'YYYY-MM-DD',
                viewFormat: 'DD MMM YYYY'
            },
            campaign.product_type == 'mcb_pkg' && {
                elem: 'max-period',
                content: iget2(
                    'b-autobudget-media-form',
                    'maksimalnyy-srok-razmeshcheniya-odnogo',
                    'Максимальный срок размещения одного пакета составляет 30 календарных дней'
                )
            }
        ];
    })

);
