block('b-autobudget-warnings').mod('media-type', 'performance')(
    def()(function() {
        var recommendations = [];

        recommendations.push(iget2('b-autobudget-warnings', 'uvelichit-maksimalnuyu-stavku-v', 'увеличить максимальную ставку в настройках стратегии;'));

        //хэлпа временно нет
        recommendations.push(iget2('b-autobudget-warnings', 'dobavit-novye-filtry', 'добавить новые фильтры'));
        //recommendations.push(iget('добавить %{new_keywords#новые фильтры};', {
        //    new_keywords: function(text) {
        //        return {
        //            block: 'link',
        //            url: u.getCommonHelpUrl('/direct/efficiency/refine-keywords.xml'),
        //            attrs: {
        //                target: 'help'
        //            },
        //            content: text
        //        };
        //    }
        //}));

        recommendations.push(iget2('b-autobudget-warnings', 'povysit-campaign-efficiency-effektivnost', 'повысить {campaign_efficiency}.', {
            campaign_efficiency: function(text) {
                return {
                    block: 'b-help-link',
                    url: u.getHelpUrl('increase-profit'),
                    text: text
                };
            }(iget2(
                'b-autobudget-warnings',
                'povysit-campaign-efficiency-effektivnost-param-campaign_efficiency',
                'эффективность рекламной кампании'
            )),

            context: 'campaign_efficiency - эффективность рекламной кампании'
        }));

        return applyNext({ recommendations: recommendations });
    }),

    content()(function() {
        return {
            elem: 'text',
            campaign: this.ctx.campaign,
            formattedCurrency: this.ctx.formattedCurrency
        };
    }),

    elem('text').content().match(function() {
        return this.ctx.campaign.autobudget_warning.bsAutobudgetProblem;
    })(function() {
        var campaign = this.ctx.campaign,
            strategy = campaign.strategy,
            result = [],
            //для смарт-баннеров bsAutobudgetProblem может принимать значения 1 или 3
            bsAutobudgetProblem = campaign.autobudget_warning.bsAutobudgetProblem;

        //Если от БК приходит bsAutobudgetProblem = 3 не отображаем первый уровень алерта
        if (bsAutobudgetProblem != 3) {
            //Если выбрана стратегия "Оптимизация количества кликов"
            if (strategy.name.match(/autobudget_avg_(cpc)_per_(camp|filter)/)) {
                //не было выбрано "Уточнить недельный бюджет" или "Уточнить максимальную цену клика"
                result.push(!(strategy.net.sum || strategy.net.bid) ?
                    iget2('b-autobudget-warnings', 'zadannaya-srednyaya-cena-za-103', 'Заданная средняя цена за клик не может быть достигнута') :
                    iget2(
                        'b-autobudget-warnings',
                        'zadannaya-srednyaya-cena-za-106',
                        'Заданная средняя цена за клик при указанных ограничениях не может быть достигнута'
                    ));

            //Если выбрана стратегия "Оптимизацияя количества конверсий"
            } else if (strategy.name.match(/autobudget_avg_(cpa)_per_(camp|filter)/)) {
                result.push(!(strategy.net.sum || strategy.net.bid) ?
                    iget2(
                        'b-autobudget-warnings',
                        'zadannaya-srednyaya-cena-konversiy',
                        'Заданная средняя цена конверсий не может быть достигнута'
                    ) :
                    iget2(
                        'b-autobudget-warnings',
                        'zadannaya-srednyaya-cena-konversiy-107',
                        'Заданная средняя цена конверсий при указанных ограничениях не может быть достигнута'
                    ));
            } else if (campaign.strategy2 && campaign.strategy2.name === 'autobudget_roi') {
                result.push((campaign.strategy2.options.sum || campaign.strategy2.options.bid) ?
                    iget2(
                        'b-autobudget-warnings',
                        'zadannyy-uroven-rentabelnosti-investiciy',
                        'Заданный уровень рентабельности инвестиций при указанных ограничениях не может быть достигнут'
                    ) :
                    iget2(
                        'b-autobudget-warnings',
                        'zadannyy-uroven-rentabelnosti-investiciy-101',
                        'Заданный уровень рентабельности инвестиций не может быть достигнут'
                    ));
            }
            result.push(': ', iget2('b-autobudget-warnings', 'dostignuta-maksimalnaya-vystavlennaya-stavka', 'достигнута максимальная выставленная ставка'));

            result.push({
                block: 'b-autobudget-warnings',
                elem: 'button',
                campaign: campaign
            });
        } else {
            result.push(iget2(
                'b-autobudget-warnings',
                'maksimalnaya-razreshyonnaya-stavka-nedostatochna-104',
                'Максимальная разрешённая ставка недостаточна для показа некоторых объявлений'
            ));
            result.push({
                block: 'b-help-link',
                mix: [{
                    block: 'b-autobudget-warnings',
                    elem: 'help'
                }],
                url: u.getHelpUrl('min-search-price'),
                icon: 'question'
            });
        }

        return result.length ?
            [
                {
                    block: 'icon-text',
                    mods: { theme: 'alert', size: 'ms' },
                    text: result
                }
            ] :
            result;
    })
);
