block('b-autobudget-warnings')(
    def().match(function() {
        return this.mods['media-type'] !== 'dynamic' && this.mods['media-type'] !== 'performance';
    })(function() {
        var campaign = this.ctx.campaign,
            recommendations = [];

        if (campaign.autobudget_warning.bsAutobudgetProblem !== 2) {
            recommendations.push(iget2('b-autobudget-warnings', 'uvelichit-maksimalnuyu-stavku-v', 'увеличить максимальную ставку в настройках стратегии;'));
        }
        if (campaign.strategy.is_net_stop) {
            recommendations.push(iget2('b-autobudget-warnings', 'podklyuchit-thematic-shows-pokazy', 'подключить {thematic_shows};', {
                thematic_shows: function(text) {
                    return {
                        block: 'link',
                        url: u.getHelpUrl('limiting-impressions-yan'),
                        attrs: {
                            target: 'help'
                        },
                        content: text
                    };
                }(iget2('b-autobudget-warnings', 'podklyuchit-thematic-shows-pokazy-param-thematic_shows', 'показы в сетях')),

                context: 'thematic_shows - показы в сетях'
            }));
        } else if (campaign.ContextLimit !== 100) {
            recommendations.push(iget2('b-autobudget-warnings', 'snyat-limitation-ogranicheniya-na', 'снять {limitation};', {
                limitation: function(text) {
                    return {
                        block: 'link',
                        url: u.getHelpUrl('limiting-impressions-yan'),
                        attrs: {
                            target: 'help'
                        },
                        content: text
                    };
                }(iget2(
                    'b-autobudget-warnings',
                    'snyat-limitation-ogranicheniya-na-param-limitation',
                    'ограничения на расход по показам в сетях'
                )),

                context: 'limitation - ограничения на расход по показам в сетях'
            }));
        }
        if (campaign.broad_match_flag === 0) {
            recommendations.push(iget2('b-autobudget-warnings', 'podklyuchit-relevant-shows-pokazy', 'подключить {relevant_shows};', {
                relevant_shows: function(text) {
                    return {
                        block: 'link',
                        url: u.getHelpUrl('related-keywords'),
                        attrs: {
                            target: 'help'
                        },
                        content: text
                    };
                }(iget2(
                    'b-autobudget-warnings',
                    'podklyuchit-relevant-shows-pokazy-param-relevant_shows',
                    'показы по дополнительным релевантным фразам'
                )),

                context: 'relevant_shows - показы по дополнительным релевантным фразам'
            }));
        } else if (campaign.broad_match_limit > 0) {
            recommendations.push(iget2('b-autobudget-warnings', 'snyat-relevant-shows-limit', 'снять {relevant_shows_limit};', {
                relevant_shows_limit: function(text) {
                    return {
                        block: 'link',
                        url: u.getHelpUrl('related-keywords'),
                        attrs: {
                            target: 'help'
                        },
                        content: text
                    };
                }(iget2(
                    'b-autobudget-warnings',
                    'snyat-relevant-shows-limit-param-relevant_shows_limit',
                    'ограничения на расход по дополнительным релевантным фразам'
                )),

                context: 'relevant_shows_limit - ограничения на расход по дополнительным релевантным фразам'
            }));
        }

        recommendations.push(iget2('b-autobudget-warnings', 'dobavit-new-keywords-novye', 'добавить {new_keywords};', {
            new_keywords: function(text) {
                return {
                    block: 'link',
                    url: u.getCommonHelpUrl('/direct/efficiency/refine-keywords.xml'),
                    attrs: {
                        target: 'help'
                    },
                    content: text
                };
            }(iget2('b-autobudget-warnings', 'dobavit-new-keywords-novye-param-new_keywords', 'новые целевые ключевые фразы')),

            context: 'new_keywords - новые целевые ключевые фразы'
        }));

        recommendations.push(iget2('b-autobudget-warnings', 'povysit-campaign-efficiency-effektivnost', 'повысить {campaign_efficiency}.', {
            campaign_efficiency: function(text) {
                return {
                    block: 'link',
                    url: u.getHelpUrl('increase-profit'),
                    attrs: {
                        target: 'help'
                    },
                    content: text
                };
            }(iget2(
                'b-autobudget-warnings',
                'povysit-campaign-efficiency-effektivnost-param-campaign_efficiency',
                'эффективность рекламной кампании'
            )),

            context: 'campaign_efficiency - эффективность рекламной кампании'
        }));

        return applyNext({ recommendations: recommendations });
    }),

    content()(function() {
        return {
            elem: 'text',
            elemMods: {
                centered: this.ctx.campaign.autobudget_warning.bsAutobudgetProblem === 2 //todo: 2?
            },
            campaign: this.ctx.campaign,
            formattedCurrency: this.ctx.formattedCurrency
        };
    }),

    elem('text').tag()('span'),

    elem('text').content().match(function() {
        return this.ctx.campaign.autobudget_warning.bsAutobudgetProblem;
    })(function() {
        var campaign = this.ctx.campaign,
            result = [],
            bsAutobudgetProblem = campaign.autobudget_warning.bsAutobudgetProblem;

        if (bsAutobudgetProblem == 4) {
            result.push(
                iget2(
                    'b-autobudget-warnings',
                    'iz-za-dostizheniya-ogranicheniya',
                    'Из-за достижения ограничения дневного бюджета для общего счёта, указанные показатели стратегии не могут быть выполнены. Пожалуйста, измените настройки.'
                )
            );
        } else if (bsAutobudgetProblem != 3) { //todo 3?
        //Если от БК приходит bsAutobudgetProblem = 3 не отображаем первый уровень алерта
            //Стратегия "Средняя цена конверсии"
            if (campaign.strategy2 && campaign.strategy2.name === 'autobudget_avg_cpa') {
                result.push((campaign.strategy2.options.sum || campaign.strategy2.options.bid) ?
                    iget2(
                        'b-autobudget-warnings',
                        'zadannaya-srednyaya-cena-konversii',
                        'Заданная средняя цена конверсии при указанных ограничениях не может быть достигнута'
                    ) :
                    iget2(
                        'b-autobudget-warnings',
                        'zadannaya-srednyaya-cena-konversii-100',
                        'Заданная средняя цена конверсии не может быть достигнута'
                    ));
            //Стратегия "Средняя рентабельность инвестиций"
            } else if (campaign.strategy2 && campaign.strategy2.name === 'autobudget_roi') {
                result.push((campaign.strategy2.options.sum || campaign.strategy2.options.bid) ?
                    iget2(
                        'b-autobudget-warnings',
                        'zadannyy-uroven-rentabelnosti-investiciy',
                        'Заданный уровень рентабельности инвестиций при указанных ограничениях не может быть достигнут'
                    ) :
                    iget2(
                        'b-autobudget-warnings',
                        'zadannyy-uroven-rentabelnosti-investiciy-101',
                        'Заданный уровень рентабельности инвестиций не может быть достигнут'
                    ));
            //Стратегия "Средняя цена установки приложения"
            } else if (campaign.strategy2 && campaign.strategy2.name === 'autobudget_avg_cpi') {
                result.push((campaign.strategy2.options.sum || campaign.strategy2.options.bid) ?
                    iget2(
                        'b-autobudget-warnings',
                        'zadannaya-srednyaya-cena-ustanovki',
                        'Заданная средняя цена установки при указанных ограничениях не может быть достигнута'
                    ) :
                    iget2(
                        'b-autobudget-warnings',
                        'zadannaya-srednyaya-cena-ustanovki-102',
                        'Заданная средняя цена установки не может быть достигнута'
                    ));
            } else if (campaign.autobudget_limit_clicks) {
                result.push(campaign.autobudget_avg_bid ?
                    iget2(
                        'b-autobudget-warnings',
                        'zadannoe-kolichestvo-klikov-pri',
                        'Заданное количество кликов при указанной средней ставке не может быть получено'
                    ) :
                    iget2('b-autobudget-warnings', 'zadannoe-kolichestvo-klikov-ne', 'Заданное количество кликов не может быть получено'));
            } else if (campaign.autobudget_sum) {
                result.push(campaign.autobudget_avg_bid ?
                    iget2(
                        'b-autobudget-warnings',
                        'zadannaya-srednyaya-cena-za',
                        'Заданная средняя цена за клик при указанном недельном бюджете не может быть достигнута'
                    ) :
                    iget2('b-autobudget-warnings', 'zadannyy-byudzhet-ne-mozhet', 'Заданный бюджет не может быть израсходован'));
            } else if (campaign.autobudget_avg_bid) {
                result.push(iget2('b-autobudget-warnings', 'zadannaya-srednyaya-cena-za-103', 'Заданная средняя цена за клик не может быть достигнута'));
            // проверка для автостратегий на период DIRECT-76275, бэкенд присылает campaign.strategy_name, но он меняется в p-campaign.bemtree.js
            } else if (
                campaign.strategy2 &&
                campaign.strategy2.options.net && (
                    campaign.strategy2.options.net.name === 'autobudget_max_impressions_custom_period' ||
                    campaign.strategy2.options.net.name === 'autobudget_max_reach_custom_period'
                )
            ) {
                result.push(iget2('b-autobudget-warnings', 'zadannyy-byudzhet-ne-mozhet', 'Заданный бюджет не может быть израсходован'));
            }

            if (bsAutobudgetProblem !== 2) { //todo: 2?
                result.push(': ', iget2('b-autobudget-warnings', 'dostignuta-maksimalnaya-vystavlennaya-stavka', 'достигнута максимальная выставленная ставка'));
            }

            if (campaign.mediaType !== 'cpm_banner' && campaign.mediaType !== 'cpm_deals') {
                result.push({
                    block: 'b-autobudget-warnings',
                    elem: 'button',
                    campaign: campaign
                });
            }
        } else {
            result.push(campaign.mediaType === 'mcbanner' ?
                iget2(
                    'b-autobudget-warnings',
                    'maksimalnaya-razreshyonnaya-stavka-nedostatochna',
                    'Максимальная разрешённая ставка недостаточна для показа некоторых баннеров'
                ) :
                iget2(
                    'b-autobudget-warnings',
                    'maksimalnaya-razreshyonnaya-stavka-nedostatochna-104',
                    'Максимальная разрешённая ставка недостаточна для показа некоторых объявлений'
                )
            );
            result.push({
                block: 'b-help-link',
                mix: [{
                    block: 'b-autobudget-warnings',
                    elem: 'help'
                }],
                url: u.getHelpUrl('min-search-price'),
                icon: 'question'
            });
        }

        return result.length ?
            [
                {
                    block: 'icon-text',
                    mods: { theme: 'alert', size: 'ms' },
                    text: result
                }
            ] :
            result;
    }),

    elem('button').content()(function() {
        return {
            block: 'dropdown',
            content: [
                {
                    block: 'button',
                    mods: {
                        pseudo: 'yes',
                        theme: 'normal'
                    },
                    mix: [{
                        block: 'dropdown',
                        elem: 'switcher'
                    }],
                    content: iget2('b-autobudget-warnings', 'rekomendacii', 'Рекомендации')
                },
                {
                    elem: 'popup',
                    elemMods: { 'has-close': 'yes' },
                    content: {
                        block: 'b-autobudget-warnings',
                        elem: 'recommendations',
                        campaign: this.ctx.campaign
                    }
                }
            ]
        };
    }),

    elem('recommendations').content()(function() {
        return [
            {
                elem: 'recommendations-title',
                campaign: this.ctx.campaign
            },
            {
                elem: 'recommendations-list',
                campaign: this.ctx.campaign
            }
        ];
    }),

    elem('recommendations-title').content()(function() {
        return iget2('b-autobudget-warnings', 'rekomendacii-105', 'Рекомендации:');
    }),

    elem('recommendations-list').tag()('ul'),
    elem('recommendations-list').content()(function() {
        return this.recommendations.map(function(item) {
            return {
                elem: 'recommendation',
                content: item
            };
        });
    }),

    elem('recommendation').tag()('li')
);
