block('b-autopay-settings').elem('autopay-mode').content()(function() {
    return [
        {
            block: 'checkbox',
            mods: {
                size: 's',
                disabled: this.modelData.disabledModeCheckbox,
                checked: this.modelData.autopay_mode == 'min_balance' ? 'yes' : ''
            },
            mix: [
                {
                    block: 'b-autopay-settings',
                    elem: 'mode-checkbox'
                },
                {
                    block: 'b-autopay-settings',
                    elem: 'model-field',
                    js: {
                        name: 'autopay_mode',
                        type: 'checkbox'
                    }
                }
            ],
            checkboxAttrs: {
                value: 'min_balance',
                name: 'autopay_mode',
                autocomplete: 'off'
            },
            text: {
                content: [
                    iget2('b-autopay-settings', 'enable-autopayment', 'Включить автоплатёж'),
                    {
                        block: 'b-help-link',
                        mods: { type: 'modal' },
                        stretched: true,
                        url: u.getHelpUrl('shared-account-autopayment')
                    }
                ]
            }
        },
        {
            block: 'b-autopay-settings',
            elem: 'min-balance-settings'
        }
    ];
});

block('b-autopay-settings').elem('min-balance-settings').content()(function() {
    var modelData = this.modelData,
        ndsValue = (+modelData.payment_sum || 0) * (100 + (+modelData.client_nds || 0)) / 100,
        formatValue = function(value, defaultValue) {
            defaultValue = (defaultValue == undefined) ? '' : u.numberFormatter.roundFormatted(+value, {
                fail: ''
            });

            return value == undefined ? defaultValue : u.numberFormatter.roundFormatted(+value, {
                fail: defaultValue
            });
        },
        controls = {};

    controls.remaining = {
        block: 'input',
        mods: {
            size: 's',
            disabled: modelData.disabledAutopaySettings
        },
        mix: [
            {
                block: 'b-autopay-settings',
                elem: 'remaining-sum'
            },
            {
                block: 'b-autopay-settings',
                elem: 'model-field',
                js: {
                    name: 'remaining_sum',
                    type: 'input'
                }
            }
        ],
        value: formatValue(modelData.remaining_sum),
        content: {
            elem: 'control',
            attrs: {
                autocomplete: 'off'
            }
        }
    };

    controls.payment = {
        block: 'input',
        mods: {
            size: 's',
            disabled: modelData.disabledAutopaySettings
        },
        mix: [
            {
                block: 'b-autopay-settings',
                elem: 'payment-sum'
            },
            {
                block: 'b-autopay-settings',
                elem: 'model-field',
                js: {
                    name: 'payment_sum',
                    type: 'input'
                }
            }
        ],
        value: formatValue(modelData.payment_sum),
        content: {
            elem: 'control',
            attrs: {
                autocomplete: 'off'
            }
        }
    };

    controls.paymentNds = {
        block: 'b-autopay-settings',
        elem: 'payment-sum-nds',
        mix: [
            {
                block: 'b-autopay-settings',
                elem: 'model-field',
                js: {
                    name: 'payment_sum_nds',
                    type: 'inline'
                }
            }
        ],
        content: formatValue(ndsValue)
    };

    return [
        iget2(
            'b-autopay-settings',
            'pri-ostatke-na-obshchem',
            'При остатке на Общем счёте {remaining} {currency} пополнять баланс на {payment} {currency}',
            {
                currency: u.currencies.getName(modelData.currency),
                remaining: controls.remaining,
                payment: controls.payment
            }
        ),
        modelData.client_nds != undefined && modelData.currency === 'RUB' && iget2('b-autopay-settings', 's-uchyotom-nds-paymentnds', ', с учётом НДС {paymentNds} {currency}', {
            currency: u.currencies.getName(modelData.currency),
            paymentNds: controls.paymentNds
        }),
        {
            block: 'b-autopay-settings',
            elem: 'min-balance-errors'
        }
    ];
});
