block('b-autopay-settings').elem('dropdown').replace()(function() {
    return {
        block: 'dropdown',
        mix: [
            {
                block: 'b-autopay-settings',
                elem: 'dropdown',
                elemMods: { type: this.ctx.type }
            },
            {
                block: 'b-dropdown-chooser',
                js: true
            }
        ],
        content: [
            {
                block: 'button',
                mods: {
                    theme: 'normal',
                    size: 's',
                    arrow: 'down',
                    disabled: this.ctx.disabled
                },
                mix: [
                    { block: 'dropdown', elem: 'switcher' },
                    {
                        block: 'b-autopay-settings',
                        elem: 'switcher',
                        elemMods: { type: this.ctx.type }
                    }
                ],
                content: u._.find(this.ctx.paymethods, function(paymethod) { return paymethod.isSelected; }).text
            },
            {
                elem: 'popup',
                mix: {
                    block: 'b-autopay-settings',
                    elem: 'dropdown-popup'
                },
                js: {
                    directions: ['bottom-left-center', 'top-left-center']
                },
                content: {
                    block: 'b-chooser',
                    mods: { theme: 'cards-list' },
                    mix: [
                        {
                            block: 'b-autopay-settings',
                            elem: 'chooser',
                            elemMods: { type: this.ctx.type }
                        },
                        {
                            block: 'b-dropdown-chooser',
                            elem: 'chooser'
                        }
                    ],
                    content: this.ctx.paymethods.map(function(paymethod) {
                        return {
                            elem: 'item',
                            js: {
                                extraParams: {
                                    type: this.ctx.type,
                                    text: paymethod.text,
                                    paymethodId: paymethod.id
                                }
                            },
                            elemMods: {
                                with: paymethod.canRemove ? 'remove' : '',
                                selected: paymethod.isSelected ? 'yes' : '',
                                disabled: paymethod.isDisabled ? 'yes' : '',
                                visibility: paymethod.isHidden ? 'hidden' : ''
                            },
                            name: paymethod.id,
                            content: paymethod.text
                        };
                    }, this)
                }
            }
        ]
    };
});
