block('b-autopay-settings').elem('payer')(
    content()(function() {
        var disabled = this.modelData.disabledPayer,
            selectedPayerId = this.modelData.person_id,
            payers = u._.filter(this.data.ur_persons || [], function(payer) {
                return payer.type === 'ur' && !payer.hidden;
            }),
            selectedPayer = payers.find(function(payer) {
                return payer.id === selectedPayerId
            });

        return [
            {
                elem: 'payer-title',
                content: iget2('b-autopay-settings', 'payer', 'Плательщик')
            },
            {
                block: 'radiobox',
                mix: [
                    {
                        block: 'b-autopay-settings',
                        elem: 'payer-type'
                    },
                    {
                        block: 'b-autopay-settings',
                        elem: 'model-field',
                        js: [
                            {
                                name: 'payerType',
                                type: 'radiobox'
                            }
                        ]
                    }
                ],
                mods: {
                    size: 's',
                    disabled: disabled
                },
                js: {
                    id: 'payer-type'
                },
                value: this.modelData.payerType,
                name: 'payer_type',
                content: [
                    {
                        block: 'radiobox',
                        elem: 'radio',
                        content: iget2('b-autopay-settings', 'natural-payer', 'Физическое лицо'),
                        controlAttrs: {
                            value: 'natural',
                            autocomplete: 'off'
                        }
                    },
                    {
                        block: 'b-autopay-settings',
                        elem: 'legal-payer-wrapper',
                        content: [
                            {
                                block: 'radiobox',
                                elem: 'radio',
                                elemMods: {
                                    disabled: this.legalPayerDisabled ? 'yes' : '',
                                    legal: 'yes'
                                },
                                controlAttrs: {
                                    value: 'legal',
                                    autocomplete: 'off'
                                },
                                content: iget2('b-autopay-settings', 'legal-payer', 'Юридическое лицо')
                            },
                            {
                                block: 'select',
                                mods: {
                                    disabled: disabled
                                },
                                mix: [
                                    { block: 'b-autopay-settings', elem: 'payer-select' },
                                    {
                                        block: 'b-autopay-settings',
                                        elem: 'model-field',
                                        js: [
                                            {
                                                name: 'person_id',
                                                type: 'select'
                                            }
                                        ]
                                    }
                                ],
                                content: [
                                    {
                                        block: 'button',
                                        content: selectedPayer ? selectedPayer.name : '&mdash;'
                                    },
                                    {
                                        elem: 'control',
                                        content: payers.map(function(payer) {
                                            return {
                                                elem: 'option',
                                                attrs: { value: payer.id, selected: payer.id === selectedPayerId ? 'selected' : undefined },
                                                content: payer.name
                                            };
                                        })
                                    }
                                ]
                            }
                        ]
                    }
                ]
            }
        ];
    })
);
