block('b-autopay-settings').elem('paymethod').content()(function() {
    var modelData = this.modelData,
        paymethod = modelData.paymethod_type,
        yandexMoneyCount = modelData.yandex_money.length,
        canUseYandexMoney = modelData.available_paymethod_types.indexOf('yandex_money') != -1,
        canUseCard = modelData.available_paymethod_types.indexOf('card') != -1;

    return [
        {
            block: 'b-autopay-settings',
            elem: 'paymethod-title',
            content: iget2('b-autopay-settings', 'sposob-oplaty', 'Способ оплаты')
        },
        canUseCard && (canUseYandexMoney ?
            {
                block: 'radiobox',
                mods: {
                    size: 's',
                    disabled: modelData.disabledAutopaySettings
                },
                mix: [
                    {
                        block: 'b-autopay-settings',
                        elem: 'paymethod-radiobox'
                    },
                    {
                        block: 'b-autopay-settings',
                        elem: 'model-field',
                        js: {
                            name: 'paymethod_type',
                            type: 'radiobox'
                        }
                    }
                ],
                js: {
                    id: 'paymethod-type'
                },
                value: paymethod == 'card' ? 'card' : undefined,
                name: 'paymethod_type',
                content: [
                    {
                        elem: 'radio',
                        content: iget2('b-autopay-settings', 'bankovskaya-karta', 'Банковская карта') + ':',
                        controlAttrs: {
                            value: 'card',
                            autocomplete: 'off'
                        }
                    },
                    {
                        block: 'b-autopay-settings',
                        elem: 'cards',
                        elemMods: {
                            disabled: modelData.disabledCards
                        }
                    }
                ]
            } :
            [
                iget2('b-autopay-settings', 'bankovskaya-karta', 'Банковская карта') + ':',
                {
                    block: 'b-autopay-settings',
                    elem: 'cards',
                    elemMods: {
                        disabled: modelData.disabledCards
                    }
                }
            ]),
        canUseYandexMoney && {
            block: 'radiobox',
            mods: {
                size: 's',
                disabled: modelData.disabledAutopaySettings || (yandexMoneyCount ? '' : 'yes')
            },
            mix: yandexMoneyCount ?
                [
                    {
                        block: 'b-autopay-settings',
                        elem: 'paymethod-radiobox'
                    },
                    {
                        block: 'b-autopay-settings',
                        elem: 'model-field',
                        js: {
                            name: 'paymethod_type',
                            type: 'radiobox'
                        }
                    }
                ] :
                undefined,
            js: yandexMoneyCount ? { id: 'paymethod-type' } : undefined,
            value: paymethod == 'yandex_money' ? 'yandex_money' : undefined,
            name: 'paymethod_type',
            content: [
                {
                    elem: 'radio',
                    controlAttrs: {
                        value: 'yandex_money',
                        autocomplete: 'off'
                    },
                    content: iget2('b-autopay-settings', 'yandeks-dengi', 'ЮMoney') + ':'
                },
                {
                    block: 'b-autopay-settings',
                    elem: 'yandex-moneys',
                    elemMods: {
                        disabled: modelData.disabledYandexMoneys
                    }
                }
            ]
        }
    ];
});

block('b-autopay-settings').elem('yandex-moneys').content()(function() {
    var modelData = this.modelData,
        paymethods = u['b-autopay-settings'].preparePaymethods(modelData.yandex_money, 'yandex-money',
            modelData.allow_bind_unbind, modelData.paymethod_id);

    return modelData.yandex_money.length ?
        {
            block: 'b-autopay-settings',
            elem: 'dropdown',
            type: 'yandex-moneys',
            disabled: modelData.disabledYandexMoneys,
            paymethods: paymethods
        } :
        [
            iget2('b-autopay-settings', 'net-koshelka', 'нет кошелька'),
            '&nbsp',
            {
                block: 'b-help-link',
                mods: {
                    type: 'modal',
                    align: 'baseline'
                },
                url: u.getHelpUrl('autopayment-no-yamoney'),
                stretched: true
            }
        ];
});

block('b-autopay-settings').elem('cards').content()(function() {
    var modelData = this.modelData,
        paymethods = u['b-autopay-settings']
            .preparePaymethods(modelData.cards, 'cards', modelData.allow_bind_unbind, modelData.paymethod_id),
        activePaymethod = paymethods.filter(function(method) {
            return method.isSelected;
        }).pop();

    return [
        {
            elem: 'payment-description-wrapper',
            content: !!modelData.cards.length && activePaymethod && {
                elem: 'payment-description',
                content: activePaymethod.text
            }
        },
        modelData.allow_bind_unbind && {
            block: 'b-modal-popup-opener',
            mix: [{
                block: 'b-autopay-settings',
                elem: 'add-card'
            }],
            disabled: modelData.disabledCards,
            url: u.getUrl('ajaxGetBindingForm', {
                csrf_token: u.consts('csrf_token'),
                ulogin: u.consts('ulogin')
            }),
            title: iget2('b-autopay-settings', 'privyazat-kartu', 'привязать карту'),
            text: iget2('b-autopay-settings', 'privyazat-kartu', 'привязать карту'),
            width: 850,
            height: 620,
            windowParams: {
                width: 850,
                height: 620
            }
        },
        {
            elem: 'card-bind-error-wrapper'
        }
    ];
});
