block('b-autopay-settings')(

    def()(function() {
        var modelData = this.ctx.modelData,
            hasAvailableYandexMoney = modelData.yandex_money.some(function(yandexMoney) {
                return !!yandexMoney.allowed_set_autopay;
            }),
            legalPayerIds = (this.data.ur_persons || [])
                .filter(function(person) {
                    return person.type === 'ur' && !person.hidden;
                })
                .map(function(person) {
                    return person.id;
                }),
            payerType = u._.contains(legalPayerIds, modelData.person_id) ? 'legal' : 'natural',
            legalPayerDisabled = legalPayerIds.length === 0;

        modelData.autopay_mode || (modelData.autopay_mode = 'none');

        if (!modelData.paymethod_type) {
            modelData.paymethod_type = hasAvailableYandexMoney && !modelData.cards.length ?
                'yandex_money' :
                'card';
        }

        modelData.payerType = payerType;
        if (payerType !== 'legal') {
            // если с бэка пришел физический плательщик, то мы можем положить в модель payer_id первого юридического
            // плательщика, чтобы не обрабатывать состояние "не выбрано" в селекте
            modelData.person_id = legalPayerIds[0];
        }

        return applyNext({
            modelData: u._.extend(modelData, u['b-autopay-settings'].calculateDisabledFields(modelData)),
            legalPayerDisabled: legalPayerDisabled
        });
    }),

    addJs()(function() {
        return {
            modelName: 'm-autopay-settings',
            modelData: this.modelData,
            legalPayerDisabled: this.legalPayerDisabled
        };
    }),

    content()(function() {
        var featuresEnabledForClient = this.data.features_enabled_for_client || {},
            newPaymentWorkflowEnabled = !!featuresEnabledForClient.new_payment_workflow_enabled;

        return [
            {
                elem: 'autopay-mode'
            },
            {
                elem: 'payer',
                elemMods: {
                    'payer-type': this.modelData.payerType,
                    hidden: newPaymentWorkflowEnabled ? 'no' : 'yes'
                }
            },
            {
                elem: 'paymethod'
            }
        ]
    }));
