BEM.DOM.decl({ block: 'b-autopay-settings', baseBlock: 'i-glue' }, {

    onSetMod: {

        js: function() {
            this.__base();

            this._canShowErrors = {};
            this._currentBalancePaymentId = this.model.get('paymethod_id');

            this._cacheBlocks()
                ._bindModelEvents()
                ._bindChooserEvents()
                ._bindInputsEvents()
                ._bindEventBus();
        }

    },

    /**
     * Находит все необходимые контролы
     * @returns {BEM}
     * @private
     */
    _cacheBlocks: function() {
        this._subMan = BEM.create('i-subscription-manager');
        this._paymentSum = this.findBlockInside(this.elem('payment-sum'), 'input');
        this._remainingSum = this.findBlockInside(this.elem('remaining-sum'), 'input');
        this._modeCheckbox = this.findBlockInside(this.elem('mode-checkbox'), 'checkbox');
        this._paymethodRadiobox = this.findBlockInside(this.elem('paymethod-radiobox'), 'radiobox');
        this._payerTypeRadioBox = this.findBlockInside(this.elem('payer-type'), 'radiobox');
        this._payerSelect = this.findBlockInside(this.elem('payer-select'), 'select');
        this._legalPayer = this.findBlockInside(this.elem('payer-select'), 'radio');

        this._yandexMoneys = {
            switcher: this.findBlockInside(this.findElem('switcher', 'type', 'yandex-moneys'), 'button'),
            chooser: this.findBlockInside(this.findElem('chooser', 'type', 'yandex-moneys'), 'b-chooser'),
            dropdown: this.findBlockInside(this.findElem('dropdown', 'type', 'yandex-moneys'), 'dropdown')
        };

        this._cards = {
            addLink: this.findBlockInside('add-card', 'link'),
            addPopup: this.findBlockInside('add-card', 'b-modal-popup-opener')
        };

        this._updateDynamicBlocksCache();

        return this;
    },

    /**
     * Обновляет кэш динамических блоков
     * @returns {BEM}
     * @private
     */
    _updateDynamicBlocksCache: function() {
        this._cards || (this._cards = {});

        u._.extend(this._cards, {
            switcher: this.findBlockInside(this.findElem('switcher', 'type', 'cards'), 'button'),
            chooser: this.findBlockInside(this.findElem('chooser', 'type', 'cards'), 'b-chooser')
        });

        return this;
    },

    /**
     * Подписывается на события модели
     * @returns {BEM}
     * @private
     */
    _bindModelEvents: function() {
        this.model
            .on('cards', 'change', this._updateCards, this)
            .on('payment_sum remaining_sum', 'change', this._checkCurrentPaymethod, this)
            .on('paymethod_type', 'change', function() {
                // DIRECT-53160: 11969: При переключении способа оплаты не срабатывает предупреждение
                this._updateDisplayRigthsErrors('payment_sum', 'remaining_sum');
            }, this)
            .on('autopay_mode paymethod_type', 'change', this._updatePaymethodType, this)
            .on('autopay_mode paymethod_type payment_sum remaining_sum paymethod_id', 'change', this._checkErrors, this)
            .on('disabledAutopaySettings', 'change', this._toggleAutopaySettings, this)
            .on('disabledYandexMoneys', 'change', this._toggleYandexMoneysControls, this)
            .on('disabledCards', 'change', this._toggleCardsControls, this)
            .on('autopay_mode', 'change', this._updateMinPaymentSum, this)
            .on('payerType', 'change', this._changePayerType, this)
            .on('disabledPayer', 'change', this._togglePayerControls, this);

        return this;
    },

    /**
     * Поднимает сумму автоплатежа до минимального значения
     * @private
     */
    _updateMinPaymentSum: function(e, params) {
        var minAutopay = u.currencies.getConst(this.model.get('currency'), 'MIN_AUTOPAY');

        if (params.value === 'min_balance' && this.model.get('payment_sum') < minAutopay) {
            this.model.set('payment_sum', minAutopay);
        }
    },

    /**
     * Подписывается на обновление списка карт после привязки
     * @returns {BEM}
     * @private
     */
    _bindEventBus: function() {
        this._cards.addPopup && this._cards.addPopup
            .getEventBus()
            .on('update-paymethods', function(e, data) {
                var cards = data.paymethods.cards;

                this._updateBindCardError(cards.length === 0 ? iget2('b-autopay-settings' , 'bind-error', 'Не удалось привязать карту') : '');

                this.model.set('cards', cards);
            }, this);

        return this;
    },

    /**
     * Подписывается на события инпутов
     * @returns {BEM}
     * @private
     */
    _bindInputsEvents: function() {
        this._remainingSum.on('focus clear', function() {
            this._updateDisplayRigthsErrors('remaining_sum');
        }, this);
        this._paymentSum.on('focus clear', function() {
            this._updateDisplayRigthsErrors('payment_sum');
        }, this);

        return this;
    },

    /**
     * Обновляет хэш отображающихся ошибок
     * @private
     */
    _updateDisplayRigthsErrors: function() {
        var canShowErrors = this._canShowErrors;

        u._.map(arguments, function(name) {
            canShowErrors[name] = true;
        });

        return this;
    },

    /**
     * Подписывается на b-chooser,
     * @returns {BEM}
     * @private
     */
    _bindChooserEvents: function() {
        if (this._cards.chooser) {
            this._subMan.on(this._cards.chooser, 'removing', this._removingCard, this);
        }

        this._subMan.wrap(BEM.blocks['b-chooser'])
            .on(this.findElem('chooser'), 'change', this._onPaymethodChooserChange, this);

        return this;
    },

    /**
     * Отписывается от b-chooser
     * @private
     */
    _unbindChooserEvents: function() {
        this._subMan.dispose();
    },

    /**
     * Сбрасывает карту/ЯД кошелек, если пользователь пытается изменить сумму пополнения выставленную представителем
     * @private
     */
    _checkCurrentPaymethod: function() {
        if (this.model.get('paymethod_type') === 'card' && this.model.get('disabledCards') === 'yes') {
            this.model.set('paymethod_id', '');
            return;
        }

        var chooser = this._yandexMoneys.chooser;

        if (chooser && chooser.getSelected().disabled) {
            // none - скрытый элемент блока b-chooser, руками его выбрать нельзя
            chooser.check('none');

            this._updatePaymethodType();
        }
    },

    /**
     * Выполняет запрос
     * @param {Object} params - параметры запроса
     * @returns {*}
     * @private
     */
    _doRequest: function(params) {
        var deferred = $.Deferred();

        this._request || (this._request = BEM.create('i-request_type_ajax', {
            url: '/registered/main.pl',
            type: 'POST',
            dataType: 'json',
            cache: false,
            callbackCtx: this
        }));

        this._request.get(
            params,
            function(data) {
                data.result == 'ok' ?
                    deferred.resolveWith(this, arguments) :
                    deferred.rejectWith(this, arguments);
            },
            function(error) {
                deferred.rejectWith(this, arguments)
            });

        return deferred.promise();
    },

    /**
     * Отписывает карту, показывает предупреждение если карта активна(участвует в автополнении)
     * @private
     */
    _removingCard: function(e, data) {
        var cardId = data.extraParams.paymethodId,
            chooser = e.block;

        if (cardId == this._currentBalancePaymentId) {
            BEM.blocks['b-confirm'].open({
                message: iget2(
                    'b-autopay-settings',
                    'pri-udalenii-karty-vybrannoy2',
                    'При удалении карты, выбранной для списания, автоплатёж будет отключен. Продолжить?'
                ),
                onYes: function() {
                    this._removeCard(cardId, true);
                },
                onNo: function() {
                    chooser.onError({ type: 'remove' });
                }
            }, this);
        } else {
            this._removeCard(cardId);
        }

    },

    /**
     * Выполняет запрос отписки карты
     * @param {String} cardId - id карты
     * @param {Boolean} resetAutopay - флаг, если true отключаем автополнение
     * @private
     */
    _removeCard: function(cardId, resetAutopay) {
        this._doRequest({
            cmd: 'ajaxUnbindCard',
            paymethod_id: cardId,
            paymethod_type: this.model.get('paymethod_type'),
            csrf_token: u.consts('csrf_token')
        })
            .done(function() {
                this._onRemoveCardSuccess(cardId, resetAutopay);
            })
            .fail(this._onRemoveCardFail);
    },

    /**
     * Карта успешно удалена
     * @param {String} cardId - id карты
     * @param {Boolean} resetAutopay - флаг, если true отключаем автополнение
     * @private
     */
    _onRemoveCardSuccess: function(cardId, resetAutopay) {
        if (resetAutopay) {
            BEM.MODEL
                .getOne('m-autopay-settings')
                .set('autopay_mode', 'none');

            this._modeCheckbox.delMod('checked');
        }

        this.model.set('cards', this.model.get('cards').filter(function(card) {
            return card.paymethod_id != cardId;
        }));
    },

    /**
     * Ошибка удаления карты
     * @private
     */
    _onRemoveCardFail: function(data) {
        BEM.blocks['b-confirm']
            .alert(typeof data.error == 'string' ? data.error : iget2('b-autopay-settings', 'oshibka-soedineniya-s-serverom', 'Ошибка соединения с сервером'));
    },

    /**
     * Перерисовывает номер выбранной карты
     * @private
     */
    _updatePaymentDescription: function(description) {
        BEM.DOM.update(this.findElem('payment-description-wrapper'), BEMHTML.apply({
            block: 'b-autopay-settings',
            elem: 'payment-description',
            content: description
        }));
    },

    /**
     * Отображает ошибку привязки карты
     * @private
     */
    _updateBindCardError: function(text) {
        BEM.DOM.update(this.findElem('card-bind-error-wrapper'), BEMHTML.apply({
            block: 'b-autopay-settings',
            elem: 'card-bind-error',
            content: text
        }));
    },

    /**
     * Обновляет список карт
     * @private
     */
    _updateCards: function() {
        this._unbindChooserEvents();

        if (this.model.get('cards').length === 1) {
            var paymethods = u['b-autopay-settings'].preparePaymethods(
                    this.model.get('cards'),
                    'cards',
                    this.model.get('allow_bind_unbind'),
                    this.model.get('paymethod_id')),
                activePaymethod = paymethods.filter(function(method) {
                    return method.isSelected;
                }).pop();

            if (activePaymethod) {
                this._updatePaymentDescription(activePaymethod.text);
                this.model.set('paymethod_id', activePaymethod.id == 'none' ? '' : activePaymethod.id);
            } else {
                this._updatePaymentDescription('');
                this.model.set('paymethod_id', '');
            }
        }

        this._updateDynamicBlocksCache()
            ._bindChooserEvents()
            ._updatePaymethodType();
    },

    /**
     * Обновляет текст кнопки
     * @param {BEM} switcher
     * @param {String} text - номер карты/ЯД кошелька
     * @returns {BEM}
     * @private
     */
    _updateSwitcherText: function(switcher, text) {
        switcher.elem('text').text(text);

        return this;
    },

    /**
     * Скрывает dropdown списка карт/ЯД кошельков
     * @param {BEM} dropdown
     * @returns {BEM}
     * @private
     */
    _hideDropdown: function(dropdown) {
        dropdown.hide();

        return this;
    },

    /**
     * Обновляет текст кнопки и поле модели paymethod_id, при изменении b-chooser
     * @param {Object} e - объект события
     * @param {Object} data - доп. данные события
     * @private
     */
    _onPaymethodChooserChange: function(e, data) {
        var store,
            paymethodId;

        if (data.selected) {
            paymethodId = data.extraParams.paymethodId;
            store = data.extraParams.type == 'cards' ?
                this._cards :
                this._yandexMoneys;

            this
                ._hideDropdown(store.dropdown)
                ._updateSwitcherText(store.switcher, data.extraParams.text)
                ._updateDisplayRigthsErrors('payment_sum', 'remaining_sum');

            this.model.set('paymethod_id', paymethodId == 'none' ? '' : paymethodId);
        }
    },

    /**
     * Делает активными/неактивными настройки автополнения
     * @param {Object} e - объект события
     * @param {Object} data - доп. данные события
     * @private
     */
    _toggleAutopaySettings: function(e, data) {
        this.setMod('autopay-mode', u.beminize(this.model.get('autopay_mode')));

        this._paymentSum.setMod('disabled', data.value);
        this._remainingSum.setMod('disabled', data.value);

        if (this._paymethodRadiobox) {
            this._paymethodRadiobox.setMod('disabled', data.value);
        }
    },

    /**
     * Выставляет поле paymethod_id при изменении способа оплаты
     * @param {Object} e - объект события
     * @param {Object} data - доп. данные события
     * @private
     */
    _updatePaymethodType: function(e, data) {
        if (this.model.get('paymethod_type') == 'card') {
            var paymethods = u['b-autopay-settings'].preparePaymethods(
                    this.model.get('cards'),
                    'cards',
                    this.model.get('allow_bind_unbind'),
                    this.model.get('paymethod_id')),
                activePaymethod = paymethods.filter(function(method) {
                    return method.isSelected;
                }).pop();

            if (activePaymethod) {
                this.model.set('paymethod_id', activePaymethod.id == 'none' ? '' : activePaymethod.id);
            } else {
                this.model.set('paymethod_id', '');
            }

            return;
        }
        var chooser = this._yandexMoneys.chooser,
            selectedId = chooser ?
                chooser.getSelected().extraParams.paymethodId : // extraParams.paymethodId может быть 'none'
                'none';

        this.model.set('paymethod_id', selectedId == 'none' ? '' : selectedId);
    },

    /**
     * Делает активными/неактивными контролы ЯД кошелька
     * @param {Object} e - объект события
     * @param {Object} data - доп. данные события
     * @returns {BEM}
     * @private
     */
    _toggleYandexMoneysControls: function(e, data) {
        this.setMod(this.elem('yandex-moneys'), 'disabled', data.value);

        if (this._yandexMoneys.switcher) {
            this._yandexMoneys.switcher.setMod('disabled', data.value);
        }

        return this;
    },

    /**
     * Делает активными/неактивными контролы банковских карт
     * @param {Object} e - объект события
     * @param {Object} data - доп. данные события
     * @returns {BEM}
     * @private
     */
    _toggleCardsControls: function(e, data) {
        if (this._cards.addLink) {
            this._cards.addLink.setMod('disabled', data.value);
        }

        if (this._cards.switcher) {
            this._cards.switcher.setMod('disabled', data.value);
        }

        return this;
    },

    /**
     * Проверяет модель, показывает ошибки
     */
    _checkErrors: function() {
        var result = this.model.validate(),
            text = [];

        if (!result.valid) {
            u._.keys(result.errorsData)
                .forEach(function(fieldName) {
                    // не показываем ошибки пустых инпутов при первом включении
                    if (this._canShowErrors[fieldName]) {
                        result.errorsData[fieldName].forEach(function(error) { text.push(error.text); });
                    }
                }, this);
        }

        this.elem('min-balance-errors').text(text.join('. '));

        this.toggleMod(this.elem('min-balance-errors'), 'show', 'yes', !!text.length);

        return this;
    },

    _changePayerType: function(e, data) {
        this.setMod(this.findElem('payer'), 'payer-type', data.value);
    },

    _togglePayerControls: function(e, data) {
        this.setMod(this.findElem('payer'), 'disabled', data.value);
        this._payerTypeRadioBox.setMod('disabled', data.value);
        this._payerSelect.setMod('disabled', data.value);
        if (this.params.legalPayerDisabled) {
            this._payerTypeRadioBox.setMod(this._payerTypeRadioBox.findElem('radio', 'legal', 'yes'), 'disabled', 'yes');
        }
    }

}, {

});
