(function() {

    u.register({
        'b-autopay-settings': {

            /**
             * Подготавливает список карт/кошельков для b-chooser
             * @param {Object[]} paymethods
             *  @param {String} paymethods.paymethod_id - id привязанной карты/кошелька в балансе
             *  @param {String} paymethods.number - Номер для отображения на странице
             *  @param {Number} paymethods.allowed_set_autopay - Может ли пользователь назначить данный вид платежа на кампанию
             *  @param {Number} paymethods.min_payment_sum - минимальная сумма платежа
             *  @param {Number} paymethods.max_payment_sum - максимальная сумма платежа
             *  @param {Number} paymethods.max_remaining_sum - максимальная сумма остатка
             * @param {String} type - тип способа оплаты
             * @param {Boolean} allowBindUnbind - флаг, можно ли отвязывать/привязывать карты
             * @param {String} [id] - id текущий привязанной карты в балансе
             * @returns {Array}
             */
            preparePaymethods: function(paymethods, type, allowBindUnbind, id) {
                var available = [],
                    disabled = [],
                    result = [],
                    selected;

                // разделяем все элементы на активные и неактивные
                // ищем выбранный
                paymethods.forEach(function(paymethod) {
                    paymethod.allowed_set_autopay ?
                        available.push(paymethod) :
                        disabled.push(paymethod);

                    if (paymethod.paymethod_id == id) {
                        selected = paymethod.paymethod_id;
                    }
                });

                if (!selected) {
                    // выбираем первый доступный
                    selected = available.length ? available[0].paymethod_id : 'none';
                }

                // скрытый элемент, руками его выбрать нельзя
                // будет выбран если нет доступных способов оплаты
                result.push({
                    id: 'none',
                    text: '———',
                    isHidden: true,
                    isSelected: selected == 'none'
                });

                return result.concat(
                    available.map(function(paymethod) {
                        return {
                            id: paymethod.paymethod_id,
                            text: paymethod.number,
                            isSelected: paymethod.paymethod_id == selected,
                            canRemove: !!paymethod.allowed_set_autopay && allowBindUnbind && type == 'cards' // можем отвязывать только карты
                        }
                    }),
                    disabled.map(function(paymethod) {
                        return {
                            id: paymethod.paymethod_id,
                            text: paymethod.number,
                            isSelected: paymethod.paymethod_id == selected,
                            isDisabled: true
                        }
                    }));
            },

            /**
             * Вычисляет состояние disabled контролов
             * @param {Object} data
             * @returns {Object}
             */
            calculateDisabledFields: function(data) {
                var result = {};

                if (data.read_only) {
                    return {
                        disabledModeCheckbox: 'yes',
                        disabledAutopaySettings: 'yes',
                        disabledYandexMoneys: 'yes',
                        disabledCards: 'yes',
                        disabledPayer: 'yes'
                    };
                }

                result.disabledModeCheckbox = '';
                result.disabledAutopaySettings = data.autopay_mode == 'none' ? 'yes' : '';
                result.disabledPayer = data.autopay_mode == 'none' ? 'yes' : '';

                if (data.autopay_mode == 'none') {
                    result.disabledYandexMoneys = 'yes';
                } else if (!data.yandex_money.length) {
                    result.disabledYandexMoneys = '';
                } else {
                    result.disabledYandexMoneys = data.paymethod_type == 'card' ? 'yes' : '';
                }

                if (data.autopay_mode == 'none') {
                    result.disabledCards = 'yes';
                } else {
                    result.disabledCards = data.paymethod_type == 'yandex_money' ? 'yes' : '';
                }

                return result;
            }

        }
    });

})();
