block('b-autopayment-info').mod('view', 'page-warning')(

    content()(function() {
        return [
            {
                block: 'icon',
                mix: {
                    block: this.block,
                    elem: 'warning-icon'
                },
                mods: {
                    'size-18': 'alert-white'
                }
            },
            {
                elem: 'description',
                title: this.ctx.title
            },
            !this.disableEditAutopay && {
                elem: 'controls',
                content: [
                    { elem: 'resume' },
                    { elem: 'link' }
                ]
            }
        ]
    }),

    elem('description').content()(function() {
        return [
            this.ctx.title && {
                elem: 'title',
                content: this.ctx.title
            },
            applyNext()
        ]
    }),

    elem('link').replace()(function() {
        return {
            block: 'button2',
            mods: {
                theme: 'normal',
                size: 'm',
                view: 'default',
                tone: 'transparent',
                type: 'link'
            },
            mix: {
                block: 'b-autopayment-info',
                elem: 'link'
            },
            url: u['autopayment'].getPageUrl({ retpath: u.getCurrentUrl() }),
            text: iget2('b-autopayment-info', 'setup-autopayment', 'Настроить автоплатёж')
        };
    }),

    match(function() {
        return this.canResumeAutopay && u['b-autopayment-info'].getErrorByCode(this.error).canResume;
    })
        .elem('resume').replace()(function() {

            return {
                block: 'button2',
                mods: {
                    theme: 'normal',
                    size: 'm',
                    view: 'default',
                    tone: 'transparent'
                },
                mix: {
                    block: 'b-autopayment-info',
                    elem: 'resume'
                },
                text: iget2('b-autopayment-info', 'vozobnovit', 'Возобновить')
            };
        })
);
