block('b-autopayment-info')(
    def()(function() {
        var ctx = this.ctx,
            paySettings = ctx.autoPaySettings || {},
            autopayMode = paySettings.autopay_mode,
            payError = paySettings.error,
            remainingSum,
            paymentSum,
            state;

        if (autopayMode === 'none') {
            state = 'off';
        } else if (payError) {
            state = 'stopped';
        } else {
            state = 'on';
        }

        // Если тип автоплатежа - "Неснижаемый остаток"
        // Передаем в контекст данные по мин. остатку и платежу
        if (autopayMode === 'min_balance') {
            remainingSum = u.currencies.formatSum(ctx.currency, paySettings.remaining_sum);
            paymentSum = u.currencies.formatSum(ctx.currency, paySettings.payment_sum);
        }

        return applyNext({
            'mods.state': state,
            remainingSum: remainingSum,
            paymentSum: paymentSum,
            error: state === 'off' ? null : payError, // Если автоплатёж выключен - сбрасываем ошибки
            canResumeAutopay: ctx.canResumeAutopay,
            disableEditAutopay: ctx.disableEditAutopay
        });
    }),

    js()(function() {
        return {
            walletCid: (this.ctx.autoPaySettings || {}).wallet_cid
        }
    }),

    content()(function() {
        return [
            { elem: 'description' },
            { elem: 'resume' }
        ]
    }),

    elem('resume').replace()(''),

    elem('description')(
        content()(function() {
            return iget2('b-autopayment-info', 'na-paymentsum-min-platezh', 'На {paymentSum} при остатке {remainingSum}', {
                remainingSum: {
                    block: this.block,
                    elem: 'sum',
                    content: this.remainingSum
                },

                paymentSum: {
                    block: this.block,
                    elem: 'sum',
                    content: this.paymentSum
                },

                context: 'paymentSum - мин. платеж; remainingSum - несгораемый остаток'
            });
        }),

        mod('state', 'off').content()(function() {
            return iget2('b-autopayment-info', 'turned-off', 'Выключен');
        }),

        match(function() { return !this.disableEditAutopay })(
            mod('state', 'off').content()(function() {
                return iget2('b-autopayment-info', 'nastroit', 'Настроить');
            }),

            content()(function() {
                return {
                    block: 'button',
                    mods: { theme: 'normal', size: 'xs', type: 'link' },
                    url: u.autopayment.getPageUrl({ retpath: u.getCurrentUrl() }),
                    content: applyNext()
                }
            })
        )
    ),

    mod('state', 'stopped')(
        elem('description').content()(function() {
            var error = u['b-autopayment-info'].getErrorByCode(this.error);

            return [
                {
                    elem: 'value',
                    content: applyNext()
                },
                {
                    elem: 'error',
                    content: [
                        error.text,
                        {
                            block: 'b-help-link',
                            mods: { type: 'modal' },
                            mix: { block: 'b-autopayment-info', elem: 'hint' },
                            url: u.getHelpUrl(error.help)
                        }
                    ]
                }
            ];
        }),

        match(function() {
            return this.canResumeAutopay && u['b-autopayment-info'].getErrorByCode(this.error).canResume;
        }).elem('resume').replace()(function() {

            return {
                block: 'link',
                mix: {
                    block: 'b-autopayment-info',
                    elem: 'resume'
                },
                text: iget2('b-autopayment-info', 'vozobnovit', 'Возобновить')
            };
        })
    )
);
