/**
    @typedef AutopaymentError
    @type {object}
    @property {String} text - текст ошибки
    @property {String} help - идентификатор ссылки на хэлп
    @property {Boolean} canResume - может ли пользователь повторить
    попытку сохранения параметров автоплатежа при данном типе ошибки
**/
u.register({
    'b-autopayment-info': {
        /**
         * Возвращает данные ошибки по ее идентификатору
         * @param {Object} code идентификатор ошибки
         * @returns {AutopaymentError}
         */
        getErrorByCode: function(code) {
            var errorList = {
                OTHER: {
                    text: iget2('b-autopayment-info', 'proizoshla-tehnicheskaya-oshibka', 'Произошла техническая ошибка'),
                    help: 'autopayment-error',
                    canResume: true
                },
                not_enough_funds: {
                    text: iget2('b-autopayment-info', 'nedostatochno-sredstv-na-karte', 'Недостаточно средств на карте или кошельке'),
                    help: 'autopayment-no-money',
                    canResume: true
                },
                expired_card: {
                    text: iget2('b-autopayment-info', 'istek-srok-deystviya-karty', 'Истек срок действия карты'),
                    help: 'autopayment-expired-card'
                }
            };

            return errorList[code] || errorList['OTHER'];
        }
    }
});
