BEM.DOM.decl('b-baby-food-label', {
    onSetMod: {
        js: function() {
            this.cachedAge = this.params.age || 11;
            this.model = BEM.MODEL.getOrCreate({ name: 'm-banner', id: this.params.modelId })
                .on('child_age', 'change', this.onExternalChange, this);

            this.dropdown = this.findBlockInside('dropdown');
            this.displayLabel = this.findBlockInside('dropdown', 'link').domElem;

            this.request = BEM.create('i-request_type_ajax', {
                url: '/registered/main.pl',
                cache: false,
                dataType: 'json',
                onError: function() {
                    BEM.blocks['b-confirm'].open({ type: 'alert', message: iget2('b-baby-food-label', 'oshibka-soedineniya-s-serverom', 'Ошибка соединения с сервером') });
                }
            });

            this
                .bindTo('item', 'click', function(e) {
                    var age = +this.findBlockInside(e.data.domElem, 'link').params.age;

                    if (age != this.cachedAge)
                        this.setAge(age);

                    this.dropdown.hide();
                });
        }
    },

    _onSaveAge: function(age) {
        var displayAge = u.pluralize([iget2('b-baby-food-label', 'mesyaca', 'месяца'), iget2('b-baby-food-label', 'mesyacev', 'месяцев'), iget2('b-baby-food-label', 'mesyacev', 'месяцев')], age);

        this.displayLabel
            .text(displayAge)
            .attr('title', displayAge);
    },

    onExternalChange: function(e, data) {
        if (data.source == this) return;

        this._onSaveAge(this.model.get('child_age'));
    },

    /*
    * Установка возрастного ограничения
    * @param {Number} age Возраст.
    */
    setAge: function(age) {
        this.cachedAge = age;

        this.model.set('child_age', age);

        this.request.get(
            {
                cmd: 'changeFlagsAjax',
                bid: this.model.get('bid'),
                flag: 'baby_food=' + age,
                csrf_token: window.csrf_token
            },
            function(result) {
                this._onSaveAge(age);
                if (result && result.success) {
                    this._onSaveAge(age);
                } else {
                    BEM.blocks['b-confirm'].alert(iget2('b-baby-food-label', 'oshibka-soedineniya-s-serverom', 'Ошибка соединения с сервером'));
                }
            },
            {
                callbackCtx: this
            }
        );
    }
});
