/**
 * Контрол множественного выбора кампаний, с возможностью "пакетного выбора" (список номеров кампаний)
 */
BEM.DOM.decl({ name: 'b-badges-multiselect', modName: 'type', modVal: 'campaigns' }, {

    onSetMod: {

        js: function() {
            this._input = this.findBlockInside('input');
            this.bindTo(
                this._input.elem('control'), 'keypress', function(e) {
                    if (e.keyCode === 13 && this._multiSelectFromInput()) {
                        // отменяем добавление текущего пункта из саджеста
                        e.stopImmediatePropagation();
                    }
                });
            this._input.on('blur', this._multiSelectFromInput, this);
            this._input.on('change', this._testMultiSelectFromInput, this);

            this.__base.apply(this, arguments);
        }

    },

    /**
     * Select All event handler
     * @param {Object} e – event object
     * @param {Object} data – data object
     * @private
     */
    _onSelectAll: function(e, data) {
        var args = arguments,
            base = this.__base;

        if (data.items && data.items.length > 500) {
            BEM.blocks['b-confirm'].open({
                message: iget2('b-badges-multiselect', 'vy-deystvitelno-hotite-dobavit', 'Вы действительно хотите добавить более 500 кампаний?'),
                onYes: function() {
                    base.apply(this, args);
                }.bind(this)
            });
        } else {
            base.apply(this, args);
        }
    },

    /**
     * Регулярное выражение, определяющее шаблон мультивставки
     */
    _multiSelectRegExp: /^([^\wА-яёЁ]*\d+[^\wА-яёЁ]+)+\d+[^\wА-яёЁ]*$/,

    /**
     * Выполняет операцию оптовой вставки из инпута
     * @returns {Boolean} была ли произведена оптовая вставка
     * @private
     */
    _multiSelectFromInput: function() {
        var val = this._input.val(),
            values;

        if (!this._multiSelectRegExp.test(val)) return false;

        values = this._provider.getByIds(val.split(/\W+/));
        values.length && this.val(this._value.concat(values));
        this._input.val('');
        this._suggest.setHideEmpty(true);

        return true;
    },

    /**
     * При изменении инпута необходимо знать, показывать нам сообщение
     * об отсутствии результатов поиска или же это мультивыбор
     * @private
     */
    _testMultiSelectFromInput: function() {
        var val = this._input.val();

        this._suggest.setHideEmpty(this._multiSelectRegExp.test(val));
    }

});
