block('b-badges-multiselect').mod('type', 'multichoice')(

    js()(function() {
        return {
            provider: {
                name: 'i-multiselect-static-provider',
                params: {
                    items: this.ctx.items || [],
                    disabledItems: this.ctx.value || []
                }
            }
        };
    }),

    elem('control').content().match(function() {
        return Boolean(this.value);
    })(function() {

        return this.value.map(function(item) {
            return {
                elem: 'badge',
                id: item.id,
                title: item.title
            };
        });
    }),

    elem('control').content()(function() {
        return {
            elem: 'wrap',
            content: [
                applyNext(),
                {
                    block: 'input',
                    mods: {
                        clear: 'no'
                    },
                    mix: [{
                        block: this.block,
                        elem: 'input'
                    }],
                    content: [
                        // placeholder здесь не работает (инпут всегда пустой),
                        // поэтому через css принудительно показываем __hint и работаем с ним
                        this.hint && {
                            elem: 'hint',
                            content: this.hint
                        },
                        {
                            elem: 'control',
                            attrs: {
                                autocomplete: 'off'
                            }
                        }
                    ]
                },
                {
                    elem: 'suggest'
                }
            ]
        };
    }),

    elem('suggest').content()(function() {
        return {
            block: 'popup2',
            mods: {
                target: 'anchor',
                theme: 'normal',
                autoclosable: 'yes'
            },
            mix: {
                block: this.block,
                elem: 'suggest-popup'
            },
            js: { directions: ['bottom', 'top'] },
            content: [
                {
                    block: 'menu',
                    mods: {
                        theme: 'normal',
                        size: 's',
                        type: 'check',
                        width: 'max'
                    },
                    mix: {
                        block: this.block,
                        elem: 'suggest-menu'
                    }
                },
                {
                    block: this.block,
                    elem: 'empty-suggest',
                    content: iget2('b-badges-multiselect', 'empty-suggest', 'Ничего не найдено')
                },
                {
                    block: this.block,
                    elem: 'suggest-actions',
                    content: [
                        {
                            block: 'button2',
                            mix: {
                                block: this.block,
                                elem: 'apply-suggest'
                            },
                            mods: {
                                theme: 'action',
                                size: 's'
                            },
                            text: iget2('b-badges-multiselect', 'apply-selected', 'Применить')
                        },
                        {
                            block: 'button2',
                            mods: {
                                theme: 'normal',
                                size: 's'
                            },
                            mix: {
                                block: this.block,
                                elem: 'select-all'
                            },
                            text: iget2('b-badges-multiselect', 'select-all', 'Выбрать все')
                        }
                    ]
                }
            ]
        };
    })
);
