/**
 * Контрол выбора набора элементов из списка c возможностью множественного выбора
 * @param {Object} params – параметры блока
 * @param {Object} [params.provider] – кастомный data-provider, реализющий интерфейс i-multiselect-provider
 * @param {String} [params.provider.name] – имя блока
 * @param {Object} [params.provider.params] – параметры инициализации
 **/
BEM.DOM.decl({ name: 'b-badges-multiselect', modName: 'type', modVal: 'multichoice' }, {

    onSetMod: {

        js: function() {
            var params = this.params,
                provider = params.provider;

            this._value = provider.params.disabledItems;
            this._provider = BEM.create({ block: provider.name }, provider.params);
            this._input = this.findBlockInside('input', 'input');
            this._suggestPopup = this.findBlockInside('suggest', 'popup2');
            this._applySuggestBtn = this.findBlockOn('apply-suggest', 'button2');
            this._suggestMenu = this.findBlockInside('suggest', 'menu');
            this._selectAllBtn = this.findBlockInside('select-all', 'button2');

            this._suggestPopup.setAnchor(this.elem('control'));
            this._updateModAddDisabled();

            this._input
                .on('focus', function() { this.setMod('focused', 'yes') }, this)
                .on('blur', function() { this.delMod('focused') }, this)
                .on('change', $.debounce(function() {
                    this._updateModEmpty();
                    this._onSuggestItemsUpdate(this._input.val());
                }, 300, this), this)
                .on({ modName: 'focused', modVal: 'yes' }, this._onSuggestPopupOpen, this);

            this._applySuggestBtn
                .on('click', this._onApplySuggestion, this);

            this._selectAllBtn
                .on('click', this._onSelectAll, this);

            this._suggestPopup
                .on({ modName: 'visible', modVal: '' }, this._clearInput, this);
        },

        empty: function(modName, modVal) {
            this._input.setMod(
                this._input.elem('hint'),
                'visibility',
                modVal === 'yes' ? 'visible' : 'hidden');
        },

        'add-disabled': function(modName, modVal) {
            this._isAddDisabled = (modVal === 'yes');

            this.toggleMod(this.elem('input'), 'hidden', 'yes', this._isAddDisabled);
        }
    },

    /**
     * Select All event handler
     * @private
     */
    _onSelectAll: function() {
        var menuItems = this._suggestMenu.findElem('item');

        this._isAllSelected = !this._isAllSelected;

        this._suggestMenu.toggleMod(menuItems, 'checked', 'yes', this._isAllSelected);
        this._renderSelectAllButtonText();
    },

    /**
     * Добавляет бейдж в BEMHTL
     * @param {Array} items - массив объектов {
     *     id: {number}
     *     title: {string}
     * }
     * @private
     */
    _renderBadges: function(items) {
        var badges = items.map(function(item) {
            return this._getBadgeBEMJSON(item.id, item.title);
        }, this);

        BEM.DOM.before(
            this._input.domElem,
            BEMHTML.apply(badges));
    },

    /**
     * Добавляет бейджи
     * @param {Array} items - массив бэйджей
     * @private
     */
    _addBadges: function(items) {
        this._value = this._value.concat(items);
        this._provider.disableItems(items);

        this._renderBadges(items);
        this._updateModEmpty();
    },

    /**
     * Удаляет бейдж
     * @param {jQuery} badgeElem – дом нода бейджа
     * @private
     */
    _removeBadge: function(badgeElem) {
        var id = this.elemParams(this.elemify(badgeElem, 'badge')).id;

        badgeElem.remove();
        this._value = this._value.filter(function(item) {
            return item.id !== id;
        });
        this._provider.enableItems([id]);
        this._updateModEmpty();
        this._clearInput();
    },

    /**
     * Очищает инпут
     * @private
     */
    _clearInput: function() {
        this._input
            .val('', { noSuggest: true });
    },

    /**
     * Устанавливает модификатор 'empty'
     * @private
     */
    _updateModEmpty: function() {
        this.toggleMod('empty', 'yes', !this._value.length);
    },

    /**
     * Обрабатывает перерисовку пунктов меню саджеста
     * @param {String} searchPhrase – греп для поиска по title по доступным для саджеста данным
     * @private
     */
    _onSuggestItemsUpdate: function(searchPhrase) {
        this._updateSuggestItems(searchPhrase);
        this._updateSuggestModEmpty();
        this._renderSuggestMenuItems();
        this._renderSelectAllButtonText();
    },

    /**
     * Выставляет модификатор 'empty' на попап саджеста
     * @private
     */
    _updateSuggestModEmpty: function() {
        this.toggleMod(this.elem('suggest-popup'), 'empty', 'yes', !this._suggestItems.length);
    },

    /**
     * Достаёт данные для саджеста из провайдера, мапит и сохраняет как свойство объекта блока
     * @param {String} searchPhrase – греп для поиска по title по доступным для саджеста данным
     * @private
     */
    _updateSuggestItems: function(searchPhrase) {
        var suggestItems = [];

        this._provider.get(searchPhrase, 0, function(providerItems) {
            if (providerItems.items && providerItems.items.length) {
                suggestItems = providerItems.items.map(function(providerItem) {
                    return {
                        title: providerItem[1].title,
                        id: providerItem[1].id
                    };
                });
            }
        });

        this._suggestItems = suggestItems;
    },

    /**
     * Обновляет BEMHTML меню саджеста
     * @private
     */
    _renderSuggestMenuItems: function() {
        var suggestMenuItems = (this._suggestItems).map(function(suggestItem) {
            return BEMHTML.apply({
                block: 'menu',
                elem: 'item',
                elemMods: { type: 'option' },
                text: suggestItem.title,
                val: suggestItem.id

            });
        });

        this._suggestMenu.setContent(suggestMenuItems);
        this._suggestPopup.setAnchor(this.elem('control'));
    },

    /**
     * Обновляет BEMHTML текст кнопки массового выбора в меню
     * @private
     */
    _renderSelectAllButtonText: function() {
        var suggestItemsNumText = this._suggestItems.length ? ' (' + (this._suggestItems.length) + ')' : '',
            selectAllButtonText = this._isAllSelected ?
                iget2('b-badges-multiselect', 'ochistit-tekushchiy-vybor', 'Очистить текущий выбор') :
                iget2('b-badges-multiselect', 'select-all', 'Выбрать все') + suggestItemsNumText;

        this._selectAllBtn.setText(selectAllButtonText);
    },

    /**
     * Обрабатывает открытие попапа саджеста
     * @private
     */
    _onSuggestPopupOpen: function() {
        if (this._suggestPopup.hasMod('visible', 'yes')) {
            return;
        }

        this._isAllSelected = true;
        this._onSelectAll();

        this._onSuggestItemsUpdate();

        this._suggestPopup.setMod('visible', 'yes');
        this._input.setMod('focused', 'yes');
    },

    /**
     * Обрабатывает клик по кнопке 'применить' в саджесте
     * @private
     */
    _onApplySuggestion: function() {
        var selected = this._suggestMenu.getVal();

        this._addBadges(this._provider.getByIds(selected));
        this._clearInput();
        this._suggestPopup.delMod('visible');
        this._updateModAddDisabled();
    },

    /**
     * Добавляет модификатор 'add-disabled' если всё уже выбрано и новые бэйджи добавить нельзя
     * @private
     */
    _updateModAddDisabled: function() {
        this._updateSuggestItems();

        this.toggleMod('add-disabled', 'yes', !this._suggestItems.length);
    },

    /**
     * Возвращает/Устанавливает массив выбранных элементов
     * @param {Array} [value]
     * @returns {Array}
     */
    val: function(value) {
        if (value) {
            this._provider.enableItems(this._value);
            this._value = value;

            this.findElem('badge').remove();
            this._renderBadges(value);

            this._provider.disableItems(this._value);

            this._clearInput();
            this._updateModEmpty();
        }

        return this._value.concat();
    }
}, {

    live: function() {

        this.liveBindTo('control', 'pointerclick', function(e) {
            if (this._isAddDisabled) {
                return;
            }

            this._onSuggestPopupOpen();
        });

        this.liveBindTo('badge-remove', 'pointerclick', function(e) {
            var badgeElem = e.data.domElem.closest(this.buildSelector('badge'));

            this._removeBadge(badgeElem);
            this._updateModAddDisabled();
            e.stopPropagation();
        });

        this.liveBindTo('clear', 'pointerclick', function() {
            this.val([]);
            this._updateModAddDisabled();
        });
    }

});
