block('b-badges-multiselect')(

    js()(function() {
        return {
            items: this.ctx.items,
            provider: this.ctx.provider,
            value: this.ctx.value,
            suggest: this.ctx.suggest || {}
        };
    }),

    def()(function() {
        return applyNext({
            'mods.empty': (this.ctx.value || []).length ? '' : 'yes',
            value: this.ctx.value,
            hint: this.ctx.hint
        });
    }),

    elem('control').content().match(function() {
        return this.value;
    })(function() {

        return this.value.map(function(item) {
            return {
                elem: 'badge',
                id: item.id,
                title: item.title
            };
        });
    }),

    elem('control').content()(function() {
        return {
            elem: 'wrap',
            content: [
                applyNext(),
                {
                    block: 'input',
                    mods: {
                        clear: 'no'
                    },
                    mix: [{
                        block: 'b-badges-multiselect',
                        elem: 'input'
                    }],
                    content: [
                        // placeholder здесь не работает (инпут всегда пустой),
                        // поэтому через css принудительно показываем __hint и работаем с ним
                        this.hint && {
                            elem: 'hint',
                            content: this.hint
                        },
                        {
                            elem: 'control',
                            attrs: {
                                autocomplete: 'off'
                            }
                        }
                    ]
                }
            ]
        };
    }),

    elem('clear')(

        attrs()(function() {
            return {
                title: iget2('b-badges-multiselect', 'ochistit-tekushchiy-vybor', 'Очистить текущий выбор')
            };
        }),

        content()(function() {
            return [
                {
                    block: 'icon',
                    mods: {
                        'size-12': 'clear'
                    }
                },
                {
                    block: 'link',
                    mix: [{
                        block: 'b-badges-multiselect',
                        elem: 'clear-link'
                    }],
                    mods: {
                        pseudo: 'yes'
                    },
                    content: iget2('b-badges-multiselect', 'ochistit', 'очистить')
                }
            ];
        })
    ),

    match(function() {
        return !this.ctx.content;
    }).content()([
        {
            elem: 'clear'
        },
        {
            elem: 'control'
        }
    ])
);
