/**
 * Контрол выбора набора элементов из списка
 * По умолчанию, истоничком данных для саджеста является блок i-multiselect-static-provider
 * @param {Object} params – параметры блока
 * @param {Array} [params.items] – список доступных элементов
 * @param {Array} [params.selected] – список предвыбранных элементов
 * @param {Object} [params.provider] – кастомный data-provider, реализющий интерфейс i-multiselect-provider
 * @param {String} [params.provider.name] – имя блока
 * @param {Object} [params.provider.params] – параметры инициализации
 **/
BEM.DOM.decl('b-badges-multiselect', {

    onSetMod: {

        js: function() {
            var params = this.params,
                providerParam = params.provider,
                providerName = providerParam && providerParam.name || 'i-multiselect-static-provider',
                providerParams = providerParam && providerParam.params || {
                    items: params.items || [],
                    disabledItems: params.value,
                    limit: function(count) { return count > 10 && count < 20 ? count : 10 }
                };

            this._value = params.value || [];
            this._provider = BEM.create({ block: providerName }, providerParams);
            this._input = this.findBlockInside('input');
            this._suggest = BEM.create(
                {
                    block: 'suggest',
                    mods: params.suggest.mods || {
                        'without-groups': 'yes',
                        'with-select-all': 'yes',
                        'empty-state': 'enabled'
                    }
                },
                {
                    owner: this,
                    input: this._input,
                    provider: this._provider,
                    updateOnEnter: false,
                    autoEnterFirstItem: true
                });

            this._suggest
                .on('select', function(e, data) {
                    this._addBadge(data.item.val());
                    this._input
                        .val('')
                        .setMod('focused', 'yes');
                }, this)
                .on('select-all select-favorite', this._onSelectAll, this);

            this._input
                .on('focus', function() { this.setMod('focused', 'yes') }, this)
                .on('blur', function() { this.delMod('focused') }, this)
                .on('change', $.debounce(function() { this._checkEmptyState();}, 300, this), this);
        },

        empty: function(modName, modVal) {
            this._input.setMod(
                this._input.elem('hint'),
                'visibility',
                modVal === 'yes' ? 'visible' : 'hidden');
        }

    },

    /**
     * Select All event handler
     * @param {Object} e – event object
     * @param {Object} data – data object
     * @private
     */
    _onSelectAll: function(e, data) {
        data.items && data.items.length && this.val(this._value.concat(data.items));

        // Необходимо ставить фокус в след тике после срабатывания blur на input (при клике в select-all)
        this.afterCurrentEvent(function() {
            this._input
                .val('')
                .setMod('focused', 'yes');
        }, this);
    },

    /**
     * Возвращает bemjson для бейджа
     * @param {String} id
     * @param {String} title
     * @private
     */
    _getBadgeBEMJSON: function(id, title) {
        return {
            block: 'b-badges-multiselect',
            elem: 'badge',
            id: id,
            title: title
        }
    },

    /**
     * Добавляет бейдж
     * @param {Object} item – элемент
     * @private
     */
    _addBadge: function(item) {
        BEM.DOM.before(
            this._input.domElem,
            BEMHTML.apply(this._getBadgeBEMJSON(item.id, item.title)));

        this._value.push(item);
        this._provider.disableItems([item]);
        this._checkEmptyState();
    },

    /**
     * Удаляет бейдж
     * @param {jQuery} badgeElem – дом нода бейджа
     * @private
     */
    _removeBadge: function(badgeElem) {
        var id = this.elemParams(this.elemify(badgeElem, 'badge')).id;

        badgeElem.remove();
        this._value = this._value.filter(function(item) {
            return item.id !== id;
        });
        this._provider.enableItems([id]);
        this._checkEmptyState();
        this._input
            .val('', { noSuggest: true })
            .setMod('focused', 'yes');
    },

    /**
     * Устанавливает модификатор _state_empty в случае необходимости
     * @private
     */
    _checkEmptyState: function() {

        var modValue = !this._value.length && this._input.val() === '' ? 'yes' : '';
        this.setMod('empty', modValue);
    },

    /**
     * Возвращает/Устанавливает массив выбранных элементов
     * @param {Array} [value]
     * @returns {Array}
     */
    val: function(value) {
        if (value) {
            var badges;

            this._provider.enableItems(this._value);
            this._value = value;
            badges = value.map(function(item) {
                return this._getBadgeBEMJSON(item.id, item.title);
            }, this);

            this.findElem('badge').remove();
            BEM.DOM.before(
                this._input.domElem,
                BEMHTML.apply(badges));

            this._provider.disableItems(this._value);
            this._input
                .val('', { noSuggest: true })
                .setMod('focused', 'yes');

            this._checkEmptyState();
        }

        return this._value.concat();
    }

}, {

    live: function() {

        this.liveBindTo('control', 'pointerclick', function(e) {
            this._input.setMod('focused', 'yes');
        });

        this.liveBindTo('badge-remove', 'pointerclick', function(e) {
            var badgeElem = e.data.domElem.closest(this.buildSelector('badge'));

            this._removeBadge(badgeElem);
            e.stopPropagation();
        });

        this.liveBindTo('clear', 'pointerclick', function() {
            this.val([]);
        });
    }

});
