block('b-banner-adv-alert')(

    // отсеиваем общие предупреждения (такие как возраст), которые не взаимоисключают другие предупреждения
    def()(function() {
        var adWarnings = u.consts('AD_WARNINGS'),
            flags = this.ctx.flags || {};

        return applyNext({
            'ctx.flags': Object.keys(flags)
                .reduce(function(res, key) {
                    adWarnings[key] && !adWarnings[key].is_common_warn && (res[key] = flags[key]);

                    return res;
                }, {})
        });
    }),

    js()(function() {
        return {
            hashFlags: this.ctx.flags,
            bid: this.ctx.bid,
            modelId: this.ctx.modelId
        };
    }),

    content()(function() {
        var adWarnings = u.consts('AD_WARNINGS'),
            hashFlags = this.ctx.flags,
            bid = this.ctx.bid,
            modelId = this.ctx.modelId,
            parents = {};

        return [
            {
                elem: 'text',
                content: [
                    {
                        elem: 'ad-warnings',
                        content: Object.keys(hashFlags).map(function(key) {
                            var flagInfo = adWarnings[key];

                            if (!flagInfo || !flagInfo.long_text || parents[flagInfo.parent]) return '';

                            if (flagInfo.parent) {
                                parents[flagInfo.parent] = true;
                            }

                            return {
                                elem: 'text-item',
                                content: {
                                    block: 'b-banner-adv-alert-item',
                                    key: key,
                                    value: hashFlags[key],
                                    text: adWarnings[key].long_text,
                                    bid: bid
                                }
                            };
                        })
                    }
                ]
            },
            this.ctx.edit && [
                {
                    elem: 'link',
                    elemMods: { type: 'hide' }
                },
                {
                    elem: 'link',
                    elemMods: { type: 'add' }
                },
                {
                    elem: 'link',
                    elemMods: { type: 'change' }
                },
                {
                    elem: 'edit',
                    bid: bid,
                    hashFlags: hashFlags
                }
            ]
        ]
    }),

    elem('edit').content()(function() {
        var adWarnings = u.consts('AD_WARNINGS');

        return Object.keys(adWarnings).sort().map(function(key) {
            var warning = adWarnings[key];

            if (warning.is_common_warn) return;

            return {
                elem: 'select-item',
                content: {
                    block: 'checkbox',
                    js: {
                        name: key,
                        text: warning.long_text
                    },
                    mods: {
                        checked: this.ctx.hashFlags[key] ? 'yes' : ''
                    },
                    text: warning.short_text
                }
            };
        }, this);
    }),

    elem('link').elemMod('type', 'hide').content()(function() {
        return {
            block: 'link',
            mods: { pseudo: 'yes' },
            content: iget2('b-banner-adv-alert', 'skryt-blok', 'Скрыть блок')
        };
    }),

    elem('link').elemMod('type', 'add').content()(function() {
        return {
            block: 'link',
            mods: { pseudo: 'yes' },
            content: iget2('b-banner-adv-alert', 'dobavit-preduprezhdenie', 'Добавить предупреждение')
        };
    }),

    elem('link').elemMod('type', 'change').content()(function() {
        return {
            block: 'link',
            mods: { pseudo: 'yes' },
            content: iget2('b-banner-adv-alert', 'izmenit-preduprezhdenie', 'Изменить предупреждение')
        };
    })
);
