BEM.DOM.decl('b-banner-adv-alert', {
    onSetMod: {
        js: function() {
            this.setMod('warnings', Object.keys(this.params.hashFlags).length ? 'some' : 'zero');

            var hideLink = this.findBlockInside(this.elem('link', 'type', 'hide'), 'link'),
                addLink = this.findBlockInside(this.elem('link', 'type', 'add'), 'link'),
                changeLink = this.findBlockInside(this.elem('link', 'type', 'change'), 'link');

            hideLink && hideLink.on('click', function() { this.setMod('edit-hidden', 'yes') }, this);
            addLink && addLink.on('click', function() { this.setMod('edit-hidden', 'yes') }, this);
            changeLink && changeLink.on('click', function() { this.setMod('edit-hidden', 'no') }, this);

            this.checkboxes = this.findBlocksInside('select-item', 'checkbox');

            // чиним двойной BEM-click на чекбоксе (триггерится когда происходит клик по лейблу)
            this.onCheckboxClick = $.debounce(this.onCheckboxClick, 25, this);

            this.checkboxes.map(function(checkbox) {
                checkbox.on('click', this.onCheckboxClick, this);
            }, this);

            this.request = BEM.create('i-request_type_ajax', {
                url: '/registered/main.pl',
                type: 'GET',
                dataType: 'json',
                cache: false,
                data: {
                    cmd: 'changeFlagsAjax',
                    bid: this.params.bid,
                    csrf_token: window.csrf_token
                }
            });
        }
    },

    onCheckboxClick: function(e) {
        this.afterCurrentEvent(function() {
            var checkbox = e.target,
                checked = checkbox.isChecked(),
                key = checkbox.params.name;

            //выставлено несколько рпедупреждений одновременно, так может быть, когда флаг medicine сконверировался в 3 флага: med_equipment, med_services, pharmacy
            if (this.checkboxes.filter(function(checkbox) { return checkbox.isChecked(); }).length > 0) {
                checked = true;
            }

            this.checkboxes.forEach(function(checkbox) {
                checkbox.delMod('checked');
            }, this);

            if (checked) {
                checkbox.setMod('checked', 'yes');
                this.addWarning(
                    key,
                    checked ? u.consts('AD_WARNINGS')[key] && u.consts('AD_WARNINGS')[key]['default'] || '1' : '0',
                    this.updateTitle.bind(this, key));
            } else {
                this.removeWarning(checkbox.params.name, this.hideTitle.bind(this));
            }
        });
    },

    addWarning: function(key, value, callback) {
        if (typeof value == 'function') {
            callback = value;
            value = false;
        }
        this.request.get({ flag: key + (value ? '=' + value : '') }, function() {
            this.trigger('warning-added', key);
            callback();
        }, { callbackCtx: this });
    },

    removeWarning: function(key, callback) {
        this.request.get({ flag: key + '=-1' }, function() {
            this.trigger('warning-removed', key);
            callback();
        }, { callbackCtx: this });
    },

    updateTitle: function(key) {
        this.setMod('title-hidden', 'no');
        BEM.DOM.update(this.elem('ad-warnings'), BEMHTML.apply({
            block: 'b-banner-adv-alert-item',
            key: key,
            value: this.params.hashFlags[key] || u.consts('AD_WARNINGS')[key]['default'],
            text: u.consts('AD_WARNINGS')[key].long_text,
            bid: this.params.bid,
            modelId: this.params.modelId
        }));
    },

    hideTitle: function() {
        this.setMod('title-hidden', 'yes');
    }
});
