BEM.DOM.decl({ block: 'b-banner-adv-alert2', elem: 'baby-food' }, {

    /**
     * Обработчик клика по ссылке внутри попапа выбора возраста
     * @param {jQuery.Event} e
     * @private
     */
    _onItemClick: function(e) {
        this._popup.hide();

        this.setAge(e.block.params.age);
    },

    /*
    * Устанавливает возрастное ограничения
    * @param {Number} age Возраст.
    */
    setAge: function(age) {
        this.getParent().changeValue('baby_food', age);
    },

    /**
     * Обработчик клика по ссылке внутри предупреждения
     * @param {jQuery.Event} e
     * @private
     */
    _onLinkClick: function(e) {
        this._popup = BEM.blocks['b-shared-popup'].getInstance({ adaptive: 'yes' }, { directions: ['bottom', 'top'] });

        var popupContent = $(this._getPopupContent());

        this._popup
            .setContent(popupContent)
            .on('show', { domNode: popupContent }, this._onPopupShow, this)
            .on('before-hide', { domNode: popupContent }, this._onPopupHide, this)
            .toggle(e.block);
    },

    /**
     * Обработчик события показа попапа
     * @param {jQuery.Event} e
     * @private
     */
    _onPopupShow: function(e) {
        // подписываемся на клик по псевдо-ссылкам внутри попапа
        BEM.blocks['link'].on(e.data.domNode, 'click', this._onItemClick, this);
    },

    /**
     * Обработчик события скрытия попапа
     * @param {jQuery.Event} e
     * @private
     */
    _onPopupHide: function(e) {
        e.block
            .un('show', this._onPopupShow, this)
            .un('before-hide', this._onPopupHide, this);

        // отписываемся от клика по псевдо-ссылкам внутри попапа
        BEM.blocks['link'].un(e.block.domElem, 'click', this._onItemClick, this);
    },

    /**
     * Строит контент попапа
     * @returns {String}
     * @private
     */
    _getPopupContent: function() {
        var value = this.params.value;

        return BEMHTML.apply([
            { elem: 'tail' },
            {
                elem: 'content',
                content: {
                    block: 'b-menu',
                    mods: { layout: 'vert', preset: 'vmenu' },
                    content: {
                        elem: 'layout-vert',
                        tag: 'ul',
                        content: u.consts('AD_WARNINGS').baby_food.variants
                            .sort(function(a, b) {
                                a = +a;
                                b = +b;

                                return (a < b) ? -1 : a == b ? 0 : 1
                            })
                            .map(function(age) {
                                var pluralizedAge =
                                    u.pluralize([iget2('b-banner-adv-alert2', 'mesyaca', 'месяца'), iget2('b-banner-adv-alert2', 'mesyacev', 'месяцев'), iget2('b-banner-adv-alert2', 'mesyacev', 'месяцев')], age);

                                return {
                                    elem: 'layout-vert-cell',
                                    tag: 'li',
                                    content: value == age ?
                                        pluralizedAge :
                                        {
                                            block: 'link',
                                            mods: { pseudo: 'yes' },
                                            js: { age: age },
                                            content: pluralizedAge
                                        }
                                };
                            })
                    }
                }
            }
        ]);
    }

}, {

    live: function() {
        this.liveInitOnBlockInsideEvent('click', 'link', function(e) {
            this._onLinkClick(e);
        });
    }

});
