block('b-banner-adv-alert2')(

    elem('warnings').content()(function() {
        var ctx = this.ctx,
            adWarnings = u.consts('AD_WARNINGS');

        return Object.keys(ctx.value || {}).reduce(function(result, key) {
            var flagInfo = adWarnings[key];

            // отсеиваем общие
            if (flagInfo && !flagInfo.is_common_warn) {
                result.push({
                    elem: 'warn',
                    key: key,
                    value: ctx.value[key],
                    canEdit: (ctx.can || {}).edit
                });
            }

            return result;
        }, []);
    }),

    elem('warn')(

        def()(
            match(function() {
                return this.ctx.canEdit;
            }).match(function() {
                return this.ctx.key === 'baby_food';
            })(function() {
                return applyCtx({
                    elem: 'baby-food',
                    mix: [{
                        elem: 'warn'
                    }],
                    value: this.ctx.value
                });
            }),

            match(function() {
                return !((u.consts('AD_WARNINGS') || {})[this.ctx.key] || {}).long_text;
            })('')
        ),

        content().match(function() {
            return !!u.consts('AD_WARNINGS')[this.ctx.key].long_text;
        })(function() {
            return iget2('common-i18n', u.consts('AD_WARNINGS')[this.ctx.key].long_text);
        }),

        content().match(function() {
            return !!u.consts('AD_WARNINGS')[this.ctx.key].long_text && this.ctx.key === 'baby_food';
        })(function() {
            return iget2(
                'b-banner-adv-alert2',
                'baby-food',
                'Проконсультируйтесь со специалистом. Для питания детей с {month} месяца.',
                {
                    count: this.ctx.value,
                    some: 'Проконсультируйтесь со специалистом. Для питания детей с {month} месяцев.',
                    many: 'Проконсультируйтесь со специалистом. Для питания детей с {month} месяцев.',
                    month: this.ctx.value
                }
            );
        })
    )
);
