/**
 * this.ctx.bid {String} Идентификатор баннера
 * this.ctx.value {Object} Значение
 * this.ctx.can {Object} Объект возможных действий
 * this.ctx.can.edit {Boolean} Возможность редактировать существующее предупреждение
 * this.ctx.can.addRemove {Boolean} Возможность добавлять/удалять существующее предупреждение
 */
block('b-banner-adv-alert2')(

    match(function() {
        return !this.ctx.elem;
    }).def()(function() {
        var adWarnings = u.consts('AD_WARNINGS'),
            ctx = this.ctx,
            valueExist = false,
            value = Object.keys(ctx.value || {}).reduce(function(result, key) {
                // выставлено описанное в AD_WARNINGS и не общее предупреждение
                if (adWarnings[key] && !adWarnings[key].is_common_warn) {
                    result[key] = ctx.value[key];
                    valueExist = true;
                }

                return result;
            }, {});

        return applyNext({
            'mods.value-missing': valueExist ? '' : 'yes',
            'ctx.value': value
        });
    }),

    js()(function() {
        return {
            value: this.ctx.value,
            can: this.ctx.can,
            bid: this.ctx.bid
        };
    }),

    content()(

        match(function() {
            return true;
        })(function() {
            return [{
                elem: 'warnings',
                value: this.ctx.value,
                can: this.ctx.can
            }];
        }),

        match(function() {
            return !!(this.ctx.can || {}).addRemove;
        })(function() {
            return (applyNext() || []).concat([
                {
                    block: 'link',
                    mods: {
                        pseudo: 'yes',
                        theme: 'without-border'
                    },
                    mix: [{
                        block: 'b-banner-adv-alert2',
                        elem: 'link',
                        elemMods: { action: 'hide' }
                    }],
                    content: iget2('b-banner-adv-alert2', 'skryt-blok', 'Скрыть блок')
                },
//                 если нет выставленных предупреждений - добавить их не можем, посему ссылка пока и не нужна,
//                 но кажется может понадобится в будущем, js для нее написан
//                {
//                    block: 'link',
//                    mods: { pseudo: 'yes', style: 'without-border' },
//                    mix: [{
//                        block: 'b-banner-adv-alert2',
//                        elem: 'link',
//                        elemMods: { action: 'add' }
//                    }],
//                    content: iget('Добавить предупреждение')
//                },
                {
                    block: 'link',
                    mods: {
                        pseudo: 'yes',
                        theme: 'without-border'
                    },
                    mix: [{
                        block: 'b-banner-adv-alert2',
                        elem: 'link',
                        elemMods: { action: 'change' }
                    }],
                    content: iget2('b-banner-adv-alert2', 'izmenit-preduprezhdenie', 'Изменить предупреждение')
                }
            ]);
        })
    )

);
