/**
 * @fires b-banner-adv-alert2#flags-change
 */
BEM.DOM.decl('b-banner-adv-alert2', {

    onSetMod: {

        js: function() {
            // чиним двойной BEM-click на чекбоксе (триггерится когда происходит клик по лейблу)
            this._onCheckboxClick = $.debounce(this._onCheckboxClick, 25, this);

            this._value = this.params.value;
        },

        loading: function(modName, modVal) {
            BEM.blocks['b-loader'].getInstance(this)[modVal ? 'show' : 'hide']();
        }

    },

    /**
     * Обработчик клика по ссылкам
     * @param {jQuery.Event} e
     * @private
     */
    _onLinkClick: function(e) {
        var domElem = e.block.domElem,
            isActionLink = this.elem('link').index(domElem) !== -1,
            action = isActionLink ? this.getMod(domElem, 'action') : '';

        switch (action) {
            case 'hide':
                return this._onHideClick(e);
            case 'add':
            case 'change':
                return this._onAddClick(e);
        }
    },

    /**
     * Обработчик клика по ссылке `Скрыть блок`
     * @param {jQuery.Event} e
     * @private
     */
    _onHideClick: function(e) {
        this.delMod('edit-panel-visible');
    },

    /**
     * Обработчик клика по ссылкам `Изменить предупреждение` и `Добавить предупреждение`
     * @param {jQuery.Event} e
     * @private
     */
    _onAddClick: function(e) {
        this.findElem('edit-panel').length || this._addEditPanel();

        this.setMod('edit-panel-visible', 'yes');
    },

    /**
     * Добавляет панель изменения предупреждений
     * @private
     */
    _addEditPanel: function() {
        BEM.DOM.append(this.domElem, BEMHTML.apply({
            block: this.__self.getName(),
            elem: 'edit-panel',
            value: this._value
        }));
    },

    /**
     * Обработчик клика по чекбоксу
     * @param {jQuery.Event} e
     * @private
     */
    _onCheckboxClick: function(e) {
        var checkbox = e.block,
            modName = checkbox.getMod('name'),
            key = modName.replace(/-/g, '_'),
            newValue = checkbox.isChecked();

        if (!newValue && Object.keys(this._value || {}).length > 1) {
            newValue = true;
            checkbox.setMod('checked', 'yes');
        }

        this.changeValue(key, newValue ? u.consts('AD_WARNINGS')[key]['default'] || 1 : -1);
    },

    /**
     * Изменяет предупреждение
     * @param {String} key Ключ изменяемого предупреждения
     * @param {Boolean|Number} value Значение изменяемого предупреждения
     */
    changeValue: function(key, value) {
        this.setMod('loading', 'yes');

        this._getRequest().get(
            { flag: key + '=' + value },
            this._onSuccessChange.bind(this, key, value),
            this._onFailChange.bind(this, key, value));
    },

    /**
     * Обработчик удачного запроса
     * @param {String} key Ключ измененного предупреждения
     * @param {Boolean|Number} value Значение измененного предупреждения
     * @param {Object} data объект с ответом сервера
     * @private
     */
    _onSuccessChange: function(key, value, data) {
        if (!data.success) return this._onFailChange(key, value);

        var changedValue = this._value = {};

        changedValue[key] = +value;

        this._getCheckboxes().forEach(function(checkbox) {
            checkbox.getMod('name') === key || checkbox.delMod('checked');
        });

        this.trigger('flags-change', { value: changedValue });
    },

    /**
     * Обработчик неудачного запроса
     * @param {String} key Ключ измененного предупреждения
     * @param {Boolean|Number} value Значение измененного предупреждения
     * @private
     */
    _onFailChange: function(key, value) {
        this.delMod('loading');

        var check = this._getCheckboxes()
            .filter(function(checkbox) { return checkbox.getMod('name') === key; })
            .pop();

        // Возвращаем измененный чекбокс
        check && check.toggleMod('checked', 'yes', '');

        BEM.blocks['b-confirm'].alert(iget2('b-banner-adv-alert2', 'proizoshla-oshibka-pri-izmenenii', 'Произошла ошибка при изменении предупреждений!'));
    },

    /**
     * Возвращает чекбоксы изменяющие предупреждения
     * @returns {BEM.DOM[]}
     * @private
     */
    _getCheckboxes: function() {
        return this._checkboxes || (this._checkboxes = this.findBlocksInside('edit-panel', 'checkbox'));
    },

    /**
     * Создает запрос
     * @returns {BEM}
     * @private
     */
    _getRequest: function() {
        return this.request || (this.request = BEM.create('i-request_type_ajax', {
            url: '/registered/main.pl',
            type: 'GET',
            dataType: 'json',
            cache: false,
            data: {
                cmd: 'changeFlagsAjax',
                bid: this.params.bid,
                csrf_token: u.consts('csrf_token')
            }
        }));
    }

}, {

    live: function() {
        this
            .liveInitOnBlockInsideEvent('click', 'link', function(e) {
                this._onLinkClick(e);
            })
            .liveInitOnBlockInsideEvent('click', 'checkbox', function(e, data) {
                this._onCheckboxClick(e, data);
            });

        return false;
    }

});
