block('b-banner-age-label')(
    def()(function() {
        var ctx = this.ctx;

        return applyNext({
            'mods.installed': ctx.age === undefined || ctx.age < 0 ? 'no' : 'yes'
        });
    }),

    js()(function() {
        return u._.extend(applyNext() || {}, {
            // Возрастные ограничения должны быть по порядку от меньшего к большему
            variants: this.ctx.variants.sort(function(a, b) {
                return a - b;
            }),
            bid: this.ctx.bid,
            modelParams: this.ctx.modelParams
        });
    }),

    content()(function() {
        var ctx = this.ctx,
            displayAge = (ctx.age != undefined && ctx.age.toString()) || ctx.defaultAge || '18';

        return [
            {
                elem: 'panel',
                content: [
                    {
                        elem: 'display-label',
                        content: [
                            {
                                elem: 'model-field',
                                tag: 'span',
                                js: {
                                    name: 'age',
                                    type: 'inline'
                                },
                                content: displayAge
                            },
                            {
                                tag: 'span',
                                content: '+'
                            }
                        ]
                    },
                    {
                        block: 'link',
                        mods: { pseudo: 'yes' },
                        mix: [{
                            block: 'b-banner-age-label',
                            elem: 'switcher'
                        }],
                        content: iget2('b-banner-age-label', 'izmenit', 'изменить')
                    },
                    {
                        block: 'b-help-link',
                        mods: { margin: 'no' },
                        mix: [{
                            block: 'b-banner-age-label',
                            elem: 'help-link'
                        }],
                        url: u.getHelpUrl('age-restriction'),
                        icon: 'question'
                    },
                    {
                        block: 'spin',
                        mix: [{
                            block: 'b-banner-age-label',
                            elem: 'spin'
                        }],
                        mods: {
                            size: 'theme',
                            theme: 'gray-16'
                        }
                    }
                ]
            },
            ctx.canToggle && {
                block: 'link',
                mix: [{
                    block: 'b-banner-age-label',
                    elem: 'link'
                }],
                mods: { pseudo: 'yes' },
                content: ctx.age === undefined || ctx.age === -1 ?
                    iget2('b-banner-age-label', 'dobavit-vozrastnoe-ogranichenie', 'Добавить возрастное ограничение') : iget2('b-banner-age-label', 'snyat-vozrastnoe-ogranichenie', 'Снять возрастное ограничение')
            }
        ];
    })
);
