(function() {
    var AGE_LABEL_TEXT_INSTALL = iget2('b-banner-age-label', 'dobavit-vozrastnoe-ogranichenie', 'Добавить возрастное ограничение'),
        AGE_LABEL_TEXT_UNINSTALL = iget2('b-banner-age-label', 'snyat-vozrastnoe-ogranichenie', 'Снять возрастное ограничение'),
        AGE_LABEL_TEXT_ERROR = iget2('b-banner-age-label', 'proizoshla-oshibka-pri-izmenenii-110', 'Произошла ошибка при изменении возрастного ограничения!'),
        endpointUrl = '/registered/main.pl',
        alert = function(message) {
            BEM.blocks['b-confirm'].open({ message: message, type: 'alert' });
        };

    BEM.DOM.decl({ block: 'b-banner-age-label', baseBlock: 'i-glue' } , {
        onSetMod: {
            js: function() {
                this.__base.apply(this, arguments);

                this.request = BEM.create('i-request_type_ajax', {
                    url: endpointUrl,
                    cache: false,
                    dataType: 'json'
                });

                BEM.blocks['i-utils'].graspSelf.call(this, {
                    spinner: 'spin on spin'
                });

                this.model = BEM.MODEL.getOrCreate(this.params.modelParams);

                this.model.on('age', 'change', function() {
                    this.setMod('installed', 'yes');
                    this.model.set('ageInstalled', true);
                }, this);

                this.link = this.findBlockOn('link', 'link');

                this.link && this.link.bindTo('click', function() {
                    this.setAge(this.getMod('installed') === 'no' ? this.model.get('age') : -1);
                }.bind(this));

                this.bindTo('switcher', 'click', function() {
                    this._getPopup()
                        .setContent(this._getPopupContent())
                        .dropElemCache('item')
                        .bindTo('item', 'click', (function(e) {
                            this.setAge(this.findBlockOn(e.data.domElem, 'link').params.age);
                        }).bind(this))
                        .toggle(this.elem('switcher'));
                });
            },

            installed: function(modName, modVal) {
                this.link.elem('inner').text(modVal === 'no' ? AGE_LABEL_TEXT_INSTALL : AGE_LABEL_TEXT_UNINSTALL);
            },

            state: {
                loading: function() {
                    this.link && this.link.setMod('disabled', 'yes');
                    this._getPopup().hide();
                    this.spinner.setMod('progress', 'yes');
                },

                done: function() {
                    this.link && this.link.delMod('disabled');
                    this.spinner.delMod('progress');
                }
            }
        },

        /**
         * Устанавливает возрастное ограничение
         * @param {Number} age возраст
         * если @age == -1, значит добавляется дефолтный возраст
         */
        setAge: function(age) {
            age = age == 0 ? 0 : +age || 18; //значение по умолчанию

            this.setMod('state', 'loading');

            this.request.get(
                {
                    cmd: 'changeFlagsAjax',
                    bid: this.model.get('bid'),
                    flag: 'age=' + age,
                    csrf_token: window.csrf_token
                },
                this._onSuccessSetAge.bind(this, age),
                this._onFailSetAge.bind(this));
        },

        _onSuccessSetAge: function(age, data) {
            this.setMod('state', 'done');

            if (data) {
                if (data.success) {
                    this.setMod('installed', age > -1 ? 'yes' : 'no');
                    this.model.set('ageInstalled', age > -1);

                    if (age > -1) this.model.set('age', age).fix();
                } else if (data.error) {
                    BEM.blocks['b-confirm'].alert(data.error);
                }
            }
        },

        _onFailSetAge: function() {
            this.setMod('state', 'done');
            BEM.blocks['b-confirm'].alert(AGE_LABEL_TEXT_ERROR);
        },

        _getPopup: function() {
            return this._popup || (this._popup = BEM.blocks['b-shared-popup'].getInstance({ animate: 'yes' }));
        },

        _getPopupContent: function() {
            return this._popupContent || (this._popupContent = BEMHTML.apply(this.params.variants.map(function(age) {
                return {
                    block: 'link',
                    mix: [
                        { block: 'b-banner-age-label', elem: 'item' },
                        { block: 'b-shared-popup', elem: 'item' }
                    ],
                    mods: { pseudo: 'yes' },
                    js: { age: age },
                    content: age + '+'
                };
            })));
        }
    });
}());
