/**
 * this.ctx.bid {String} Идентификатор баннера
 * this.ctx.value {Object} Значение
 * this.ctx.can {Object} Объект возможных действий
 * this.ctx.can.edit {Boolean} Возможность редактировать существующее предупреждение
 * this.ctx.can.addRemove {Boolean} Возможность добавлять/удалять существующее предупреждение
 */
block('b-banner-age-label2')(

    def()(function() {
        return applyNext({
            value: (this.ctx.flags || {}).age
        });
    }),

    // если значение не выставлено
    match(function() {
        return !(this.value || this.value == 0);
    }).mix()([{
        mods: { 'value-missing': 'yes' }
    }]),

    js()(function() {
        return {
            value: this.value,
            can: this.ctx.can,
            bid: this.ctx.bid
        };
    }),

    content()(function() {
        var can = this.ctx.can || {},
            result = [{
                elem: 'label',
                content: [
                    {
                        elem: 'value',
                        content: this.value
                    },
                    {
                        tag: 'span',
                        content: '+'
                    }
                ]
            }];

        can.edit && result.push({
            elem: 'edit-panel',
            content: [
                {
                    block: 'link',
                    mods: {
                        pseudo: 'yes',
                        theme: 'without-border'
                    },
                    mix: [{
                        block: 'b-banner-age-label2',
                        elem: 'link',
                        elemMods: { action: 'edit' }
                    }],
                    content: iget2('b-banner-age-label2', 'izmenit', 'изменить')
                },
                {
                    block: 'b-help-link',
                    mods: {
                        margin: 'no',
                        type: 'modal'
                    },
                    mix: [{
                        block: 'b-banner-age-label2',
                        elem: 'help-link'
                    }],
                    url: u.getHelpUrl('age-restriction')
                },
                {
                    block: 'spin',
                    mix: [{
                        block: 'b-banner-age-label2',
                        elem: 'spin'
                    }],
                    mods: {
                        size: 'theme',
                        theme: 'gray-16'
                    }
                }
            ]
        });

        can.addRemove && result.push({
            elem: 'add-remove',
            content: [
                {
                    block: 'link',
                    mods: {
                        pseudo: 'yes',
                        theme: 'without-border'
                    },
                    mix: [{
                        block: 'b-banner-age-label2',
                        elem: 'link',
                        elemMods: { action: 'add' }
                    }],
                    content: iget2('b-banner-age-label2', 'dobavit-vozrastnoe-ogranichenie', 'Добавить возрастное ограничение')
                },
                {
                    block: 'link',
                    mods: {
                        pseudo: 'yes',
                        theme: 'without-border'
                    },
                    mix: [{
                        block: 'b-banner-age-label2',
                        elem: 'link',
                        elemMods: { action: 'remove' }
                    }],
                    content: iget2('b-banner-age-label2', 'snyat-vozrastnoe-ogranichenie', 'Снять возрастное ограничение')
                }
            ]
        });

        return result;
    })
);
