/**
 * @fires b-banner-age-label2#flags-change
 */
BEM.DOM.decl('b-banner-age-label2', {

    onSetMod: {

        js: function() {
            this._value = this.params.value;
        },

        state: {

            loading: function() {
                this.setMod(this.elem('add-remove'), 'disabled', 'yes');

                this._getPopup().hide();

                this._getSpinner().setMod('progress', 'yes');
            },

            done: function() {
                this.delMod(this.elem('add-remove'), 'disabled');

                this._getSpinner().delMod('progress');
            }

        }

    },

    onElemSetMod: {

        'add-remove': {

            disabled: function(elem, modName, modVal) {
                this.findBlocksInside(elem, 'link').forEach(function(bLink) {
                    bLink.setMod(modName, modVal);
                });
            }

        }

    },

    /**
     * Возвращает инстанс прелоадера
     * @returns {BEM}
     * @private
     */
    _getSpinner: function() {
        return this._spinner || (this._spinner = this.findBlockOn('spin', 'spin'));
    },

    /**
     * Создает запрос
     * @returns {BEM}
     * @private
     */
    _getRequest: function() {
        return this._request || (this._request = BEM.create('i-request_type_ajax', {
            url: '/registered/main.pl',
            cache: false,
            dataType: 'json'
        }));
    },

    /**
     * Обработчик клика по ссылке
     * @param {jQuery.Event} e
     * @private
     */
    _onLinkClick: function(e) {
        var domElem = e.block.domElem,
            isActionLink = this.elem('link').index(domElem) !== -1,
            action = isActionLink ? this.getMod(domElem, 'action') : '';

        switch (action) {
            case 'add':
                return this._onAddClick(e);
            case 'remove':
                return this._onRemoveClick(e);
            case 'edit':
                return this._onEditClick(e);
        }
    },

    /**
     * Обработчик клика по ссылке "Добавить возрастное ограничение"
     * @private
     */
    _onAddClick: function() {
        this.setAge(u.consts('AD_WARNINGS').age['default']);
    },

    /**
     * Обработчик клика по ссылке "Удалить возрастное ограничение"
     * @private
     */
    _onRemoveClick: function() {
        this.setAge(-1);
    },

    /**
     * Обработчик клика по ссылке "Изменить"
     * @param {jQuery.Event} e
     * @private
     */
    _onEditClick: function(e) {
        this._getPopup()
            .setContent(this._getPopupContent())
            .unbindFrom('item', 'click')
            .dropElemCache('item')
            .bindTo('item', 'click', (function(e) {
                var link = this.findBlockOn(e.data.domElem, 'link');

                link && this.setAge(link.params.age);
            }).bind(this))
            .toggle(e.block.domElem);
    },

    /**
     * Устанавливает возрастное ограничение
     * @param {Number|String} age возраст
     */
    setAge: function(age) {
        age = age == 0 ? 0 : +age;

        this.setMod('state', 'loading');

        this._getRequest().get(
            {
                cmd: 'changeFlagsAjax',
                bid: this.params.bid,
                flag: 'age=' + age,
                csrf_token: u.consts('csrf_token')
            },
            this._onSuccessSetAge.bind(this, age),
            this._onFailSetAge.bind(this));
    },

    /**
     * Обработчик успешного изменения возраста
     * @param {Number} age
     * @param {Object} data
     * @private
     */
    _onSuccessSetAge: function(age, data) {
        this.trigger('flags-change', {
            value: { age: age }
        })
    },

    /**
     * Обработчик неудачного изменения возраста
     * @private
     */
    _onFailSetAge: function() {
        this.setMod('state', 'done');

        BEM.blocks['b-confirm'].alert(iget2('b-banner-age-label2', 'proizoshla-oshibka-pri-izmenenii-110', 'Произошла ошибка при изменении возрастного ограничения!'));
    },

    /**
     * Возвращает экземпляр попапа
     * @returns {BEM}
     * @private
     */
    _getPopup: function() {
        return this._popup || (this._popup = BEM.blocks['b-shared-popup'].getInstance({ animate: 'yes' }));
    },

    /**
     * Строит контент попапа выбора возраста
     * @returns {String}
     * @private
     */
    _getPopupContent: function() {
        var currentValue = this._value,
            variantsBemJson = ((u.consts('AD_WARNINGS').age || {}).variants || [])
            // Возрастные ограничения должны быть по порядку от меньшего к большему
            .sort(function(a, b) { return a - b; })
            .map(function(age) {
                return currentValue == age ?
                {
                    block: 'b-banner-age-label2',
                    elem: 'item',
                    mix: [{ block: 'b-shared-popup', elem: 'item' }],
                    content: age + '+'
                } :
                {
                    block: 'link',
                    mix: [
                            { block: 'b-banner-age-label2', elem: 'item' },
                            { block: 'b-shared-popup', elem: 'item' }
                    ],
                    mods: { pseudo: 'yes' },
                    js: { age: age },
                    content: age + '+'
                };
            });

        return BEMHTML.apply(variantsBemJson);
    }

}, {

    live: function() {
        this.liveInitOnBlockInsideEvent('click', 'link', function(e) {
            this._onLinkClick(e);
        });

        return false;
    }

});
