/**
 * modelParams {Object} - параметры модели кампании
 * selectedLength {Number} - число групп, выбранных на редактирование
 */
block('b-banner-age-labels-edit')(

    js()(function() { return { modelParams: this.ctx.modelParams } }),

    content()(function() {
        return {
            elem: 'form',
            variants: this.ctx.variants,
            selectedLength: this.ctx.selectedLength,
            mixBlock: this.ctx.mixBlock
        };
    }),

    elem('form').content()(function() {
        var ctx = this.ctx,
            mixBlock = ctx.mixBlock,
            selectedLength = ctx.selectedLength;

        return [
            {
                tag: 'h2',
                content: [
                    {
                        elem: 'header',
                        mix: { block: mixBlock, elem: 'header' },
                        content: [
                            iget2('b-banner-age-labels-edit', 'izmenit-vozrastnoe-ogranichenie', 'Изменить возрастное ограничение'),
                            {
                                block: 'b-help-link',
                                mix: [{ block: 'b-banner-age-labels-edit', elem: 'help' }],
                                url: u.getHelpUrl('age-restriction'),
                                icon: 'question',
                                content: iget2('b-banner-age-labels-edit', 'pomoshch', 'Помощь')
                            }
                        ]
                    }
                ]
            },
            {
                elem: 'comment',
                mix: { block: mixBlock, elem: 'note' },
                content: iget2(
                    'b-banner-age-labels-edit',
                    'izmenenie-budet-primeneno-tolko',
                    'Изменение будет применено только к объявлениям с доступным возрастным ограничением'
                )
            },
            {
                elem: 'comment',
                mix: [
                    { block: mixBlock, elem: 'note' },
                    { block: mixBlock, elem: 'bordered' }
                ],
                content: iget2('b-banner-age-labels-edit', 'vybrano-obyavleniy-s', 'Выбрано объявлений: {foo}', {
                    foo: selectedLength
                })
            },
            {
                elem: 'container',
                mix: [
                    { block: mixBlock, elem: 'row' },
                    { block: mixBlock, elem: 'row-first' },
                    { block: mixBlock, elem: 'row-last' }
                ],
                variants: this.ctx.variants
            },
            {
                elem: 'errors',
                mix: { block: mixBlock, elem: 'row-errors' }
            },
            {
                elem: 'footer',
                mix: { block: mixBlock, elem: 'footer' },
                content: [
                    { elem: 'accept' },
                    { elem: 'cancel' }
                ]
            }
        ];
    }),

    elem('container').content()(function() {
        return {
            block: 'radiobox',
            name: 'age_multiedit',
            value: this.ctx.variants[0],
            content: this.ctx.variants.map(function(age, index) {
                return {
                    elem: 'radio',
                    elemMods: { checked: index === 0 ? 'yes' : '' },
                    mix: [{
                        block: 'b-banner-age-labels-edit',
                        elem: 'age-item'
                    }],
                    content: [age, '+'],
                    controlAttrs: { value: age }
                };
            })
        };
    }),

    elem('accept').content()(function() {
        return {
            block: 'button',
            mods: { theme: 'action' },
            mix: { block: this.ctx.mixBlock, elem: 'footer-button' },
            content: iget2('b-banner-age-labels-edit', 'sohranit', 'Сохранить')
        };
    }),

    elem('cancel').content()(function() {
        return {
            block: 'button',
            mix: { block: this.ctx.mixBlock, elem: 'footer-button' },
            content: iget2('b-banner-age-labels-edit', 'otmena', 'Отмена')
        };
    })
);
