(function() {
    var getter = BEM.blocks['i-utils'].getter,
        graspSelf = BEM.blocks['i-utils'].graspSelf,
        endpointUrl = '/registered/main.pl';

    BEM.DOM.decl('b-banner-age-labels-edit', {
        onSetMod: {
            js: function() {
                this.request = BEM.create('i-request_type_ajax', {
                    url: endpointUrl,
                    cache: false,
                    dataType: 'json',
                    type: 'POST'
                });

                graspSelf.call(this, {
                    popup: 'popup outside',
                    ageBox: 'radiobox inside container',
                    acceptButton: 'button inside accept',
                    cancelButton: 'button inside cancel'
                });

                this.cancelButton.on('click', this.onCancel, this);
                this.acceptButton.on('click', this.onAccept, this);
                this.campaign = BEM.MODEL.getOne(this.params.modelParams);
                this.groups = this.campaign.getSelectedGroups();
            }
        },

        onCancel: function() {
            this.popup.hide();
        },

        onAccept: function() {
            var _this = this,
                age = this.ageBox.val();

            this.request.get({
                cmd: 'changeGroupFlagsAjax',
                adgroup_ids: this.groups.map(getter('get', 'adgroup_id')).join(','),
                flag: 'age=' + age
            }, function(result) {
                var bidsWithChanges = result.bids_with_changes;

                _this.groups.forEach(function(group) {
                    //@heliarian со страницы кампании можно установить возрастное ограничение только для всех баннеров группы
                    group.getBanners().forEach(function(banner) {
                        if (bidsWithChanges.indexOf(String(banner.get('bid'))) !== -1) {
                            banner.set('age', age);
                            // для нового b-banner-preview2
                            banner.setHashFlagsWithDependencies({ age: age });
                        }
                    });
                });
                _this.popup.hide();
            }, function() {
                _this.popup.hide();
                BEM.blocks['b-confirm'].alert(iget2('b-banner-age-labels-edit', 'oshibka-soedineniya', 'Ошибка соединения!'));
            });

        }
    });
}());
