block('b-banner-aiming-popup')(
    js()(function() {
        return {
            bannerId: this.ctx.bannerId,
            ulogin: this.ctx.ulogin,
            cid: this.ctx.cid
        };
    }),

    content()(function() {
        var WEEK_LENGTH = 7,
            bid = this.ctx.bid,
            ulogin = this.ctx.ulogin,
            cid = this.ctx.cid,
            dateFrom = u.moment().subtract(WEEK_LENGTH, 'days').format('YYYY-MM-DD'),
            dateTo = u.moment().format('YYYY-MM-DD'),
            statUrl = u.getUrl('showStat', {
                cid: cid,
                detail: 'Yes',
                types: 'days',
                ulogin: ulogin,
                single_camp: 1,
                stat_type: 'moc',
                show_stat: 1,
                date_from: dateFrom,
                date_to: dateTo
            });

        return {
            elem: 'wrapper',
            content: [
                {
                    elem: 'header',
                    content: iget2('b-banner-aiming-popup', 'header', 'Нацеливание на объявление') + ' ' + bid
                },
                {
                    elem: 'details',
                    content: [
                        {
                            elem: 'details-item',
                            content: [
                                iget2('b-banner-aiming-popup', 'details-item-1', 'При нажатии кнопки «Нацелиться» у Вас будет 10 минут, чтобы посмотреть свое объявление на любой площадке, на которой оно может быть показано. Например там, где объявление уже показывалось. Список таких площадок можно посмотреть в {master-otchetov}', {
                                    'master-otchetov': {
                                        block: 'link',
                                        url: statUrl,
                                        content: iget2('b-banner-aiming-popup', 'master-otchetov', 'Мастере отчетов')
                                    }
                                }),
                            ]

                        },
                        {
                            elem: 'details-item',
                            content: iget2('b-banner-aiming-popup', 'details-item-2', 'Нельзя нацеливаться на несколько объявлений сразу – при повторном нацеливании будет отображаться новое объявление.')
                        }
                    ]
                },
                {
                    block: 'checkbox',
                    theme: 'pseudo',
                    mix: [
                        { block: 'b-banner-aiming-popup', elem: 'checkbox' }
                    ],
                    mods: { checked: 'yes' },
                    size: 's',
                    text: iget2('b-banner-aiming-popup', 'allow-cookie', 'Разрешить использование cookie')
                },
                {
                    elem: 'cookie-disclaimer',
                    content: iget2('b-banner-aiming-popup', 'cookie-disclaimer', 'Мы используем файлы cookie, чтобы нацелиться на объявление. Время жизни cookie – 10 минут.')
                },
                {
                    elem: 'btn-section',
                    content: [
                        {
                            block: 'button2',
                            mods: {
                                theme: 'action',
                                size: 'n',
                            },
                            mix: [
                                { block: 'b-banner-aiming-popup', elem: 'action-btn' }
                            ],
                            text: iget2('b-banner-aiming-popup', 'action', 'Нацелиться')
                        },
                        {
                            block: 'button2',
                            mods: {
                                theme: 'normal',
                                size: 'n',
                            },
                            mix: [
                                { block: 'b-banner-aiming-popup', elem: 'cancel-btn' }
                            ],
                            text: iget2('b-banner-aiming-popup', 'cancel', 'Отмена')
                        }
                    ]
                }
            ]
        };
    }),

    elem('header')(
        tag()('h3'),

        content()(function() {
            return [{
                tag: 'span',
                content: applyNext()
            }, {
                block: 'b-help-link',
                mods: {
                    type: 'modal'
                },
                stretched: true,
                url: u.getHelpUrl('view-ad'),
                icon: true
            }];
        })
    ),

    elem('details-list-item')(
        tag()('p')
    ),

    elem('details-header')(
        tag()('p')
    ),

    elem('cookie-disclaimer')(
        tag()('p')
    )
);
