BEM.DOM.decl({ block: 'b-banner-aiming-popup', implements: 'i-modal-popup-inner-block-interface' }, {
    _cookieLifetimeMinutes: 10,

    onSetMod: {
        js: function() {
            u.graspSelf.call(this, {
                _checkbox: 'checkbox on checkbox',
                _actionBtn: 'button2 on action-btn',
                _cancelBtn: 'button2 on cancel-btn'
            });

            this._checkbox.on('change', this._onCheckboxChange, this);
            this._actionBtn.on('click', this._action, this);
            this._cancelBtn.on('click', this.hide, this);
        }
    },

    destruct: function() {
        this._checkbox.un('change', this._onCheckboxChange, this);
        this._actionBtn.un('click', this._action, this);
        this._cancelBtn.un('click', this.hide, this);

        this.__base.apply(this, arguments);
    },

    hide: function() {
        this._modal && this._modal.hide({ source: 'force' });
        this._popup.destruct();
    },

    _action: function() {
        this._actionBtn.setMod('progress', 'yes');
        this._openYandexIframe();
    },

    _openYandexIframe: function() {
        var bannerId = this.params.bannerId,
            ulogin = this.params.ulogin,
            csrfToken = u.consts('csrf_token'),
            retpath = u.getUrl('ok'),
            endpoint = 'web-api/banner_aiming/set_cookie',
            frameUrl = u.formatUrl({
                host: u.consts('SCRIPT_CLEAR'),
                path: endpoint,
                query: {
                    ulogin: ulogin,
                    bid: bannerId,
                    cookie_ttl: this._cookieLifetimeMinutes,
                    csrf_token: csrfToken,
                    retpath: encodeURIComponent(retpath)
                }
            });

        BEM.DOM.append(this.domElem, BEMHTML.apply({
            block: 'b-iframe',
            mix: [
                { block: 'b-banner-aiming-popup', elem: 'yandex-iframe' }
            ],
            mods: {
                hidden: 'yes'
            },
            src: frameUrl
        }));

        this._yandexIframe = this.findBlockOn('yandex-iframe', 'b-iframe');
        this._yandexIframe.bindTo('load', this._handleYandexIframeLoad.bind(this));
    },

    _handleYandexIframeLoad: function(event) {
        var targetReached,
            adocMatch,
            adoc;

        try {
            targetReached = event.target.contentDocument.body.innerText === 'ok';
            if (targetReached) {
                adocMatch = $.cookie('yp').match(/.*?(\d+\.adoc\..+)(?:\.\w|$)/);
                if (adocMatch) {
                    adoc = adocMatch[1];
                    this._openAdfoxIframe(adoc);
                } else {
                    throw new Error();
                }
            } else {
                throw new Error();
            }
        } catch (err) {
            this._bannerAimingAcknowledgeError();
        }
        this._yandexIframe.destruct();
    },

    _openAdfoxIframe: function(adoc) {
        var adfoxHost = 'https://ads.adfox.ru',
            adfoxEnpoint = 'set_yp',
            retpath = u.getUrl('ok'),
            frameUrl = u.formatUrl({
                host: adfoxHost,
                path: adfoxEnpoint,
                query: {
                    yp: encodeURIComponent(adoc),
                    ttl: this._cookieLifetimeMinutes,
                    retpath: encodeURIComponent(retpath)
                }
            });

        BEM.DOM.append(this.domElem, BEMHTML.apply({
            block: 'b-iframe',
            mix: [
                { block: 'b-banner-aiming-popup', elem: 'adfox-iframe' }
            ],
            mods: {
                hidden: 'yes'
            },
            src: frameUrl
        }));

        this._adfoxIframe = this.findBlockOn('adfox-iframe', 'b-iframe');
        this._adfoxIframe.bindTo('load', this._handleAdfoxIframeLoad.bind(this));
    },

    _handleAdfoxIframeLoad: function(event) {
        var targetReached;

        try {
            targetReached = event.target.contentDocument.body.innerText === 'ok';
            if (targetReached) {
                this._bannerAimingAcknowledgeSuccess();
            } else {
                throw new Error();
            }
        } catch (err) {
            this._openRollbackIframe();
        }
        this._adfoxIframe.destruct();
    },

    _openRollbackIframe: function() {
        var ulogin = this.params.ulogin,
            csrfToken = u.consts('csrf_token'),
            retpath = u.getUrl('ok'),
            endpoint = 'web-api/banner_aiming/reset_cookie',
            frameUrl = u.formatUrl({
                host: u.consts('SCRIPT_CLEAR'),
                path: endpoint,
                query: {
                    ulogin: ulogin,
                    csrf_token: csrfToken,
                    retpath: encodeURIComponent(retpath)
                }
            });

        BEM.DOM.append(this.domElem, BEMHTML.apply({
            block: 'b-iframe',
            mix: [
                { block: 'b-banner-aiming-popup', elem: 'rollback-iframe' }
            ],
            mods: {
                hidden: 'yes'
            },
            src: frameUrl
        }));

        this._rollbackIframe = this.findBlockOn('rollback-iframe', 'b-iframe');
        this._rollbackIframe.bindTo('load', this._handleRollbackIframeLoad.bind(this));
    },

    _handleRollbackIframeLoad: function() {
        this._bannerAimingAcknowledgeError();
        this._rollbackIframe.destruct();
    },

    _bannerAimingAcknowledgeSuccess: function() {
        BEM.blocks['b-confirm'].open({
            message: iget2('b-banner-aiming-popup', 'success', 'Нацеливание прошло успешно. У Вас есть 10 минут, чтобы посмотреть объявление.'),
            type: 'alert',
            fromPopup: this._popup,
            onYes: this.hide.bind(this)
        });
        this._actionBtn.setMod('progress', false);
    },

    _bannerAimingAcknowledgeError: function() {
        BEM.blocks['b-confirm'].alert(iget2('b-banner-aiming-popup', 'error', 'Что-то пошло не так. Попробуйте нацелиться еще раз позже.'), this._popup);
        this._actionBtn.setMod('progress', false);
    },

    _setModal: function(modal) {
        this._modal = modal;
        this._popup = modal.domElem.bem('popup');
    },

    isChanged: function() {
        var deferred = $.Deferred();

        deferred.resolve(false);

        return deferred;
    },

    _onCheckboxChange: function(event, newValue) {
        this._actionBtn.setMod('disabled', !newValue.checked && 'yes');
    }
});
