/**
 * Показывает все варианты отображения объявления в сети
 */
block('b-banner-all-formats')(

    js()(function() {
        var activePreviewIndex = u._.findIndex(this.ctx.previews, function(preview) {
            return preview.name === this.ctx.active;
        }, this);

        activePreviewIndex = activePreviewIndex == -1 ? 0 : activePreviewIndex;

        return {
            activePreviewIndex: activePreviewIndex
        }
    }),

    elem('title').tag()('p'),

    content()(function() {
        var previews = this.ctx.previews,
            active = this.ctx.active,
            body = [];

        if (previews.length) {

            active = active || previews[0].name;

            if (previews.length == 1) { // если превью одно, то прячем меню выбра табов
                body.push(
                    { elem: 'hr' },
                    {
                        elem: previews[0].name,
                        data: previews[0].data
                    }
                )
            } else {
                body.push({
                    elem: 'tabs',
                    tabs: previews.map(function(preview) {
                        return {
                            name: preview.name,
                            isActive: active == preview.name,
                            tab: {
                                block: 'b-banner-all-formats',
                                elem: preview.name,
                                data: preview.data
                            }
                        }
                    })
                });
            }
        }

        return [
            {
                elem: 'header'
            },
            {
                elem: 'body',
                content: body
            }
        ];
    })
)
